/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class DeleteItem
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/items/{itemId}";
    private String method = "DELETE";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String itemId;
    private String namespace;
    private Boolean force;
    private String storeId;

    @Deprecated
    public DeleteItem(String itemId, String namespace, Boolean force, String storeId) {
        this.itemId = itemId;
        this.namespace = namespace;
        this.force = force;
        this.storeId = storeId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.itemId != null) {
            pathParams.put("itemId", this.itemId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("force", this.force == null ? null : Arrays.asList(String.valueOf(this.force)));
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.itemId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 204) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("force", "None");
        result.put("storeId", "None");
        return result;
    }

    public static DeleteItemBuilder builder() {
        return new DeleteItemBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getForce() {
        return this.force;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public static class DeleteItemBuilder {
        private String itemId;
        private String namespace;
        private Boolean force;
        private String storeId;

        DeleteItemBuilder() {
        }

        public DeleteItemBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public DeleteItemBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public DeleteItemBuilder force(Boolean force) {
            this.force = force;
            return this;
        }

        public DeleteItemBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public DeleteItem build() {
            return new DeleteItem(this.itemId, this.namespace, this.force, this.storeId);
        }

        public String toString() {
            return "DeleteItem.DeleteItemBuilder(itemId=" + this.itemId + ", namespace=" + this.namespace + ", force=" + this.force + ", storeId=" + this.storeId + ")";
        }
    }
}

