/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.iap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.AppleIAPConfigInfo;
import net.accelbyte.sdk.api.platform.models.AppleIAPConfigRequest;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateAppleIAPConfig
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/iap/config/apple";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private AppleIAPConfigRequest body;

    @Deprecated
    public UpdateAppleIAPConfig(String namespace, AppleIAPConfigRequest body) {
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public AppleIAPConfigRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public AppleIAPConfigInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new AppleIAPConfigInfo().createFromJson(json);
    }

    public static UpdateAppleIAPConfigBuilder builder() {
        return new UpdateAppleIAPConfigBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public AppleIAPConfigRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(AppleIAPConfigRequest body) {
        this.body = body;
    }

    public static class UpdateAppleIAPConfigBuilder {
        private String namespace;
        private AppleIAPConfigRequest body;

        UpdateAppleIAPConfigBuilder() {
        }

        public UpdateAppleIAPConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateAppleIAPConfigBuilder body(AppleIAPConfigRequest body) {
            this.body = body;
            return this;
        }

        public UpdateAppleIAPConfig build() {
            return new UpdateAppleIAPConfig(this.namespace, this.body);
        }

        public String toString() {
            return "UpdateAppleIAPConfig.UpdateAppleIAPConfigBuilder(namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

