/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.iap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.IAPConsumeHistoryPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryUserIAPConsumeHistory
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/users/{userId}/iap/consume/history";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private String endTime;
    private Integer limit;
    private Integer offset;
    private String startTime;
    private String status;
    private String type;

    @Deprecated
    public QueryUserIAPConsumeHistory(String namespace, String userId, String endTime, Integer limit, Integer offset, String startTime, String status, String type) {
        this.namespace = namespace;
        this.userId = userId;
        this.endTime = endTime;
        this.limit = limit;
        this.offset = offset;
        this.startTime = startTime;
        this.status = status;
        this.type = type;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("endTime", this.endTime == null ? null : Arrays.asList(this.endTime));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("startTime", this.startTime == null ? null : Arrays.asList(this.startTime));
        queryParams.put("status", this.status == null ? null : Arrays.asList(this.status));
        queryParams.put("type", this.type == null ? null : Arrays.asList(this.type));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public IAPConsumeHistoryPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new IAPConsumeHistoryPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("endTime", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("startTime", "None");
        result.put("status", "None");
        result.put("type", "None");
        return result;
    }

    public static QueryUserIAPConsumeHistoryBuilder builder() {
        return new QueryUserIAPConsumeHistoryBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static class QueryUserIAPConsumeHistoryBuilder {
        private String namespace;
        private String userId;
        private String endTime;
        private Integer limit;
        private Integer offset;
        private String startTime;
        private String status;
        private String type;

        public QueryUserIAPConsumeHistoryBuilder status(String status) {
            this.status = status;
            return this;
        }

        public QueryUserIAPConsumeHistoryBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        public QueryUserIAPConsumeHistoryBuilder type(String type) {
            this.type = type;
            return this;
        }

        public QueryUserIAPConsumeHistoryBuilder typeFromEnum(Type type) {
            this.type = type.toString();
            return this;
        }

        QueryUserIAPConsumeHistoryBuilder() {
        }

        public QueryUserIAPConsumeHistoryBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryUserIAPConsumeHistoryBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public QueryUserIAPConsumeHistoryBuilder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public QueryUserIAPConsumeHistoryBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryUserIAPConsumeHistoryBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryUserIAPConsumeHistoryBuilder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public QueryUserIAPConsumeHistory build() {
            return new QueryUserIAPConsumeHistory(this.namespace, this.userId, this.endTime, this.limit, this.offset, this.startTime, this.status, this.type);
        }

        public String toString() {
            return "QueryUserIAPConsumeHistory.QueryUserIAPConsumeHistoryBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", endTime=" + this.endTime + ", limit=" + this.limit + ", offset=" + this.offset + ", startTime=" + this.startTime + ", status=" + this.status + ", type=" + this.type + ")";
        }
    }

    public static enum Type {
        APPLE("APPLE"),
        EPICGAMES("EPICGAMES"),
        GOOGLE("GOOGLE"),
        OCULUS("OCULUS"),
        PLAYSTATION("PLAYSTATION"),
        STADIA("STADIA"),
        STEAM("STEAM"),
        TWITCH("TWITCH"),
        XBOX("XBOX");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Status {
        FAIL("FAIL"),
        PENDING("PENDING"),
        SUCCESS("SUCCESS");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

