/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.iap;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.PlayStationReconcileRequest;
import net.accelbyte.sdk.api.platform.models.PlayStationReconcileResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicReconcilePlayStationStore
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/users/{userId}/iap/psn/sync";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private PlayStationReconcileRequest body;

    @Deprecated
    public PublicReconcilePlayStationStore(String namespace, String userId, PlayStationReconcileRequest body) {
        this.namespace = namespace;
        this.userId = userId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public PlayStationReconcileRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public List<PlayStationReconcileResult> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PlayStationReconcileResult>>(){});
    }

    public static PublicReconcilePlayStationStoreBuilder builder() {
        return new PublicReconcilePlayStationStoreBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public PlayStationReconcileRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(PlayStationReconcileRequest body) {
        this.body = body;
    }

    public static class PublicReconcilePlayStationStoreBuilder {
        private String namespace;
        private String userId;
        private PlayStationReconcileRequest body;

        PublicReconcilePlayStationStoreBuilder() {
        }

        public PublicReconcilePlayStationStoreBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicReconcilePlayStationStoreBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicReconcilePlayStationStoreBuilder body(PlayStationReconcileRequest body) {
            this.body = body;
            return this;
        }

        public PublicReconcilePlayStationStore build() {
            return new PublicReconcilePlayStationStore(this.namespace, this.userId, this.body);
        }

        public String toString() {
            return "PublicReconcilePlayStationStore.PublicReconcilePlayStationStoreBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

