/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.iap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.IAPItemMappingInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetIAPItemMapping
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/iap/item/mapping";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList(new String[0]);
    private String locationQuery = null;
    private String namespace;
    private String platform;

    @Deprecated
    public GetIAPItemMapping(String namespace, String platform) {
        this.namespace = namespace;
        this.platform = platform;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("platform", this.platform == null ? null : Arrays.asList(this.platform));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public IAPItemMappingInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new IAPItemMappingInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("platform", "None");
        return result;
    }

    public static GetIAPItemMappingBuilder builder() {
        return new GetIAPItemMappingBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public static class GetIAPItemMappingBuilder {
        private String namespace;
        private String platform;

        public GetIAPItemMappingBuilder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public GetIAPItemMappingBuilder platformFromEnum(Platform platform) {
            this.platform = platform.toString();
            return this;
        }

        GetIAPItemMappingBuilder() {
        }

        public GetIAPItemMappingBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetIAPItemMapping build() {
            return new GetIAPItemMapping(this.namespace, this.platform);
        }

        public String toString() {
            return "GetIAPItemMapping.GetIAPItemMappingBuilder(namespace=" + this.namespace + ", platform=" + this.platform + ")";
        }
    }

    public static enum Platform {
        APPLE("APPLE"),
        EPICGAMES("EPICGAMES"),
        GOOGLE("GOOGLE"),
        OCULUS("OCULUS"),
        PLAYSTATION("PLAYSTATION"),
        STADIA("STADIA"),
        STEAM("STEAM"),
        TWITCH("TWITCH"),
        XBOX("XBOX");

        private String value;

        private Platform(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

