/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.entitlement;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.BulkOperationResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class RevokeUserEntitlements
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/users/{userId}/entitlements/revoke/byIds";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private String entitlementIds;

    @Deprecated
    public RevokeUserEntitlements(String namespace, String userId, String entitlementIds) {
        this.namespace = namespace;
        this.userId = userId;
        this.entitlementIds = entitlementIds;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("entitlementIds", this.entitlementIds == null ? null : Arrays.asList(this.entitlementIds));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.userId == null) {
            return false;
        }
        return this.entitlementIds != null;
    }

    public BulkOperationResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new BulkOperationResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("entitlementIds", "None");
        return result;
    }

    public static RevokeUserEntitlementsBuilder builder() {
        return new RevokeUserEntitlementsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEntitlementIds() {
        return this.entitlementIds;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setEntitlementIds(String entitlementIds) {
        this.entitlementIds = entitlementIds;
    }

    public static class RevokeUserEntitlementsBuilder {
        private String namespace;
        private String userId;
        private String entitlementIds;

        RevokeUserEntitlementsBuilder() {
        }

        public RevokeUserEntitlementsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public RevokeUserEntitlementsBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public RevokeUserEntitlementsBuilder entitlementIds(String entitlementIds) {
            this.entitlementIds = entitlementIds;
            return this;
        }

        public RevokeUserEntitlements build() {
            return new RevokeUserEntitlements(this.namespace, this.userId, this.entitlementIds);
        }

        public String toString() {
            return "RevokeUserEntitlements.RevokeUserEntitlementsBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", entitlementIds=" + this.entitlementIds + ")";
        }
    }
}

