/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.entitlement;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.EntitlementPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryUserEntitlements
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/users/{userId}/entitlements";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private Boolean activeOnly;
    private String appType;
    private String entitlementClazz;
    private String entitlementName;
    private List<String> features;
    private List<String> itemId;
    private Integer limit;
    private Integer offset;

    @Deprecated
    public QueryUserEntitlements(String namespace, String userId, Boolean activeOnly, String appType, String entitlementClazz, String entitlementName, List<String> features, List<String> itemId, Integer limit, Integer offset) {
        this.namespace = namespace;
        this.userId = userId;
        this.activeOnly = activeOnly;
        this.appType = appType;
        this.entitlementClazz = entitlementClazz;
        this.entitlementName = entitlementName;
        this.features = features;
        this.itemId = itemId;
        this.limit = limit;
        this.offset = offset;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("activeOnly", this.activeOnly == null ? null : Arrays.asList(String.valueOf(this.activeOnly)));
        queryParams.put("appType", this.appType == null ? null : Arrays.asList(this.appType));
        queryParams.put("entitlementClazz", this.entitlementClazz == null ? null : Arrays.asList(this.entitlementClazz));
        queryParams.put("entitlementName", this.entitlementName == null ? null : Arrays.asList(this.entitlementName));
        queryParams.put("features", this.features == null ? null : this.features);
        queryParams.put("itemId", this.itemId == null ? null : this.itemId);
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public EntitlementPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new EntitlementPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("activeOnly", "None");
        result.put("appType", "None");
        result.put("entitlementClazz", "None");
        result.put("entitlementName", "None");
        result.put("features", "multi");
        result.put("itemId", "multi");
        result.put("limit", "None");
        result.put("offset", "None");
        return result;
    }

    public static QueryUserEntitlementsBuilder builder() {
        return new QueryUserEntitlementsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public Boolean getActiveOnly() {
        return this.activeOnly;
    }

    public String getAppType() {
        return this.appType;
    }

    public String getEntitlementClazz() {
        return this.entitlementClazz;
    }

    public String getEntitlementName() {
        return this.entitlementName;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public List<String> getItemId() {
        return this.itemId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setActiveOnly(Boolean activeOnly) {
        this.activeOnly = activeOnly;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public void setEntitlementClazz(String entitlementClazz) {
        this.entitlementClazz = entitlementClazz;
    }

    public void setEntitlementName(String entitlementName) {
        this.entitlementName = entitlementName;
    }

    public void setFeatures(List<String> features) {
        this.features = features;
    }

    public void setItemId(List<String> itemId) {
        this.itemId = itemId;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public static class QueryUserEntitlementsBuilder {
        private String namespace;
        private String userId;
        private Boolean activeOnly;
        private String entitlementName;
        private List<String> features;
        private List<String> itemId;
        private Integer limit;
        private Integer offset;
        private String appType;
        private String entitlementClazz;

        public QueryUserEntitlementsBuilder appType(String appType) {
            this.appType = appType;
            return this;
        }

        public QueryUserEntitlementsBuilder appTypeFromEnum(AppType appType) {
            this.appType = appType.toString();
            return this;
        }

        public QueryUserEntitlementsBuilder entitlementClazz(String entitlementClazz) {
            this.entitlementClazz = entitlementClazz;
            return this;
        }

        public QueryUserEntitlementsBuilder entitlementClazzFromEnum(EntitlementClazz entitlementClazz) {
            this.entitlementClazz = entitlementClazz.toString();
            return this;
        }

        QueryUserEntitlementsBuilder() {
        }

        public QueryUserEntitlementsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryUserEntitlementsBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public QueryUserEntitlementsBuilder activeOnly(Boolean activeOnly) {
            this.activeOnly = activeOnly;
            return this;
        }

        public QueryUserEntitlementsBuilder entitlementName(String entitlementName) {
            this.entitlementName = entitlementName;
            return this;
        }

        public QueryUserEntitlementsBuilder features(List<String> features) {
            this.features = features;
            return this;
        }

        public QueryUserEntitlementsBuilder itemId(List<String> itemId) {
            this.itemId = itemId;
            return this;
        }

        public QueryUserEntitlementsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryUserEntitlementsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryUserEntitlements build() {
            return new QueryUserEntitlements(this.namespace, this.userId, this.activeOnly, this.appType, this.entitlementClazz, this.entitlementName, this.features, this.itemId, this.limit, this.offset);
        }

        public String toString() {
            return "QueryUserEntitlements.QueryUserEntitlementsBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", activeOnly=" + this.activeOnly + ", appType=" + this.appType + ", entitlementClazz=" + this.entitlementClazz + ", entitlementName=" + this.entitlementName + ", features=" + this.features + ", itemId=" + this.itemId + ", limit=" + this.limit + ", offset=" + this.offset + ")";
        }
    }

    public static enum EntitlementClazz {
        APP("APP"),
        CODE("CODE"),
        ENTITLEMENT("ENTITLEMENT"),
        LOOTBOX("LOOTBOX"),
        MEDIA("MEDIA"),
        OPTIONBOX("OPTIONBOX"),
        SUBSCRIPTION("SUBSCRIPTION");

        private String value;

        private EntitlementClazz(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum AppType {
        DEMO("DEMO"),
        DLC("DLC"),
        GAME("GAME"),
        SOFTWARE("SOFTWARE");

        private String value;

        private AppType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

