/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.entitlement;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.AppEntitlementPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicQueryUserEntitlementsByAppType
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/users/{userId}/entitlements/byAppType";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private Integer limit;
    private Integer offset;
    private String appType;

    @Deprecated
    public PublicQueryUserEntitlementsByAppType(String namespace, String userId, Integer limit, Integer offset, String appType) {
        this.namespace = namespace;
        this.userId = userId;
        this.limit = limit;
        this.offset = offset;
        this.appType = appType;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("appType", this.appType == null ? null : Arrays.asList(this.appType));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.userId == null) {
            return false;
        }
        return this.appType != null;
    }

    public AppEntitlementPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new AppEntitlementPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("appType", "None");
        return result;
    }

    public static PublicQueryUserEntitlementsByAppTypeBuilder builder() {
        return new PublicQueryUserEntitlementsByAppTypeBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getAppType() {
        return this.appType;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public static class PublicQueryUserEntitlementsByAppTypeBuilder {
        private String namespace;
        private String userId;
        private Integer limit;
        private Integer offset;
        private String appType;

        public PublicQueryUserEntitlementsByAppTypeBuilder appType(String appType) {
            this.appType = appType;
            return this;
        }

        public PublicQueryUserEntitlementsByAppTypeBuilder appTypeFromEnum(AppType appType) {
            this.appType = appType.toString();
            return this;
        }

        PublicQueryUserEntitlementsByAppTypeBuilder() {
        }

        public PublicQueryUserEntitlementsByAppTypeBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicQueryUserEntitlementsByAppTypeBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicQueryUserEntitlementsByAppTypeBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PublicQueryUserEntitlementsByAppTypeBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public PublicQueryUserEntitlementsByAppType build() {
            return new PublicQueryUserEntitlementsByAppType(this.namespace, this.userId, this.limit, this.offset, this.appType);
        }

        public String toString() {
            return "PublicQueryUserEntitlementsByAppType.PublicQueryUserEntitlementsByAppTypeBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", limit=" + this.limit + ", offset=" + this.offset + ", appType=" + this.appType + ")";
        }
    }

    public static enum AppType {
        DEMO("DEMO"),
        DLC("DLC"),
        GAME("GAME"),
        SOFTWARE("SOFTWARE");

        private String value;

        private AppType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

