/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.entitlement;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.TimedOwnership;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetMyEntitlementOwnershipBySku
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/users/me/entitlements/ownership/bySku";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String entitlementClazz;
    private String sku;

    @Deprecated
    public PublicGetMyEntitlementOwnershipBySku(String namespace, String entitlementClazz, String sku) {
        this.namespace = namespace;
        this.entitlementClazz = entitlementClazz;
        this.sku = sku;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("entitlementClazz", this.entitlementClazz == null ? null : Arrays.asList(this.entitlementClazz));
        queryParams.put("sku", this.sku == null ? null : Arrays.asList(this.sku));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.sku != null;
    }

    public TimedOwnership parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new TimedOwnership().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("entitlementClazz", "None");
        result.put("sku", "None");
        return result;
    }

    public static PublicGetMyEntitlementOwnershipBySkuBuilder builder() {
        return new PublicGetMyEntitlementOwnershipBySkuBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEntitlementClazz() {
        return this.entitlementClazz;
    }

    public String getSku() {
        return this.sku;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setEntitlementClazz(String entitlementClazz) {
        this.entitlementClazz = entitlementClazz;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public static class PublicGetMyEntitlementOwnershipBySkuBuilder {
        private String namespace;
        private String sku;
        private String entitlementClazz;

        public PublicGetMyEntitlementOwnershipBySkuBuilder entitlementClazz(String entitlementClazz) {
            this.entitlementClazz = entitlementClazz;
            return this;
        }

        public PublicGetMyEntitlementOwnershipBySkuBuilder entitlementClazzFromEnum(EntitlementClazz entitlementClazz) {
            this.entitlementClazz = entitlementClazz.toString();
            return this;
        }

        PublicGetMyEntitlementOwnershipBySkuBuilder() {
        }

        public PublicGetMyEntitlementOwnershipBySkuBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGetMyEntitlementOwnershipBySkuBuilder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public PublicGetMyEntitlementOwnershipBySku build() {
            return new PublicGetMyEntitlementOwnershipBySku(this.namespace, this.entitlementClazz, this.sku);
        }

        public String toString() {
            return "PublicGetMyEntitlementOwnershipBySku.PublicGetMyEntitlementOwnershipBySkuBuilder(namespace=" + this.namespace + ", entitlementClazz=" + this.entitlementClazz + ", sku=" + this.sku + ")";
        }
    }

    public static enum EntitlementClazz {
        APP("APP"),
        CODE("CODE"),
        ENTITLEMENT("ENTITLEMENT"),
        LOOTBOX("LOOTBOX"),
        MEDIA("MEDIA"),
        OPTIONBOX("OPTIONBOX"),
        SUBSCRIPTION("SUBSCRIPTION");

        private String value;

        private EntitlementClazz(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

