/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.entitlement;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.TimedOwnership;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetMyEntitlementOwnershipByItemId
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/users/me/entitlements/ownership/byItemId";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String entitlementClazz;
    private String itemId;

    @Deprecated
    public PublicGetMyEntitlementOwnershipByItemId(String namespace, String entitlementClazz, String itemId) {
        this.namespace = namespace;
        this.entitlementClazz = entitlementClazz;
        this.itemId = itemId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("entitlementClazz", this.entitlementClazz == null ? null : Arrays.asList(this.entitlementClazz));
        queryParams.put("itemId", this.itemId == null ? null : Arrays.asList(this.itemId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.itemId != null;
    }

    public TimedOwnership parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new TimedOwnership().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("entitlementClazz", "None");
        result.put("itemId", "None");
        return result;
    }

    public static PublicGetMyEntitlementOwnershipByItemIdBuilder builder() {
        return new PublicGetMyEntitlementOwnershipByItemIdBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEntitlementClazz() {
        return this.entitlementClazz;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setEntitlementClazz(String entitlementClazz) {
        this.entitlementClazz = entitlementClazz;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public static class PublicGetMyEntitlementOwnershipByItemIdBuilder {
        private String namespace;
        private String itemId;
        private String entitlementClazz;

        public PublicGetMyEntitlementOwnershipByItemIdBuilder entitlementClazz(String entitlementClazz) {
            this.entitlementClazz = entitlementClazz;
            return this;
        }

        public PublicGetMyEntitlementOwnershipByItemIdBuilder entitlementClazzFromEnum(EntitlementClazz entitlementClazz) {
            this.entitlementClazz = entitlementClazz.toString();
            return this;
        }

        PublicGetMyEntitlementOwnershipByItemIdBuilder() {
        }

        public PublicGetMyEntitlementOwnershipByItemIdBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGetMyEntitlementOwnershipByItemIdBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public PublicGetMyEntitlementOwnershipByItemId build() {
            return new PublicGetMyEntitlementOwnershipByItemId(this.namespace, this.entitlementClazz, this.itemId);
        }

        public String toString() {
            return "PublicGetMyEntitlementOwnershipByItemId.PublicGetMyEntitlementOwnershipByItemIdBuilder(namespace=" + this.namespace + ", entitlementClazz=" + this.entitlementClazz + ", itemId=" + this.itemId + ")";
        }
    }

    public static enum EntitlementClazz {
        APP("APP"),
        CODE("CODE"),
        ENTITLEMENT("ENTITLEMENT"),
        LOOTBOX("LOOTBOX"),
        MEDIA("MEDIA"),
        OPTIONBOX("OPTIONBOX"),
        SUBSCRIPTION("SUBSCRIPTION");

        private String value;

        private EntitlementClazz(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

