/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.entitlement;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.EntitlementDecrement;
import net.accelbyte.sdk.api.platform.models.EntitlementDecrementResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicConsumeUserEntitlement
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/users/{userId}/entitlements/{entitlementId}/decrement";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String entitlementId;
    private String namespace;
    private String userId;
    private EntitlementDecrement body;

    @Deprecated
    public PublicConsumeUserEntitlement(String entitlementId, String namespace, String userId, EntitlementDecrement body) {
        this.entitlementId = entitlementId;
        this.namespace = namespace;
        this.userId = userId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.entitlementId != null) {
            pathParams.put("entitlementId", this.entitlementId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public EntitlementDecrement getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.entitlementId == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public EntitlementDecrementResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new EntitlementDecrementResult().createFromJson(json);
    }

    public static PublicConsumeUserEntitlementBuilder builder() {
        return new PublicConsumeUserEntitlementBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getEntitlementId() {
        return this.entitlementId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public EntitlementDecrement getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setEntitlementId(String entitlementId) {
        this.entitlementId = entitlementId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(EntitlementDecrement body) {
        this.body = body;
    }

    public static class PublicConsumeUserEntitlementBuilder {
        private String entitlementId;
        private String namespace;
        private String userId;
        private EntitlementDecrement body;

        PublicConsumeUserEntitlementBuilder() {
        }

        public PublicConsumeUserEntitlementBuilder entitlementId(String entitlementId) {
            this.entitlementId = entitlementId;
            return this;
        }

        public PublicConsumeUserEntitlementBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicConsumeUserEntitlementBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicConsumeUserEntitlementBuilder body(EntitlementDecrement body) {
            this.body = body;
            return this;
        }

        public PublicConsumeUserEntitlement build() {
            return new PublicConsumeUserEntitlement(this.entitlementId, this.namespace, this.userId, this.body);
        }

        public String toString() {
            return "PublicConsumeUserEntitlement.PublicConsumeUserEntitlementBuilder(entitlementId=" + this.entitlementId + ", namespace=" + this.namespace + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

