/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.entitlement;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.TimedOwnership;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetUserEntitlementOwnershipByItemId
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/users/{userId}/entitlements/ownership/byItemId";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private String entitlementClazz;
    private String itemId;

    @Deprecated
    public GetUserEntitlementOwnershipByItemId(String namespace, String userId, String entitlementClazz, String itemId) {
        this.namespace = namespace;
        this.userId = userId;
        this.entitlementClazz = entitlementClazz;
        this.itemId = itemId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("entitlementClazz", this.entitlementClazz == null ? null : Arrays.asList(this.entitlementClazz));
        queryParams.put("itemId", this.itemId == null ? null : Arrays.asList(this.itemId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.userId == null) {
            return false;
        }
        return this.itemId != null;
    }

    public TimedOwnership parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new TimedOwnership().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("entitlementClazz", "None");
        result.put("itemId", "None");
        return result;
    }

    public static GetUserEntitlementOwnershipByItemIdBuilder builder() {
        return new GetUserEntitlementOwnershipByItemIdBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEntitlementClazz() {
        return this.entitlementClazz;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setEntitlementClazz(String entitlementClazz) {
        this.entitlementClazz = entitlementClazz;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public static class GetUserEntitlementOwnershipByItemIdBuilder {
        private String namespace;
        private String userId;
        private String itemId;
        private String entitlementClazz;

        public GetUserEntitlementOwnershipByItemIdBuilder entitlementClazz(String entitlementClazz) {
            this.entitlementClazz = entitlementClazz;
            return this;
        }

        public GetUserEntitlementOwnershipByItemIdBuilder entitlementClazzFromEnum(EntitlementClazz entitlementClazz) {
            this.entitlementClazz = entitlementClazz.toString();
            return this;
        }

        GetUserEntitlementOwnershipByItemIdBuilder() {
        }

        public GetUserEntitlementOwnershipByItemIdBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetUserEntitlementOwnershipByItemIdBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public GetUserEntitlementOwnershipByItemIdBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public GetUserEntitlementOwnershipByItemId build() {
            return new GetUserEntitlementOwnershipByItemId(this.namespace, this.userId, this.entitlementClazz, this.itemId);
        }

        public String toString() {
            return "GetUserEntitlementOwnershipByItemId.GetUserEntitlementOwnershipByItemIdBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", entitlementClazz=" + this.entitlementClazz + ", itemId=" + this.itemId + ")";
        }
    }

    public static enum EntitlementClazz {
        APP("APP"),
        CODE("CODE"),
        ENTITLEMENT("ENTITLEMENT"),
        LOOTBOX("LOOTBOX"),
        MEDIA("MEDIA"),
        OPTIONBOX("OPTIONBOX"),
        SUBSCRIPTION("SUBSCRIPTION");

        private String value;

        private EntitlementClazz(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

