/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.entitlement;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.EntitlementInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetEntitlement
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/entitlements/{entitlementId}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String entitlementId;
    private String namespace;

    @Deprecated
    public GetEntitlement(String entitlementId, String namespace) {
        this.entitlementId = entitlementId;
        this.namespace = namespace;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.entitlementId != null) {
            pathParams.put("entitlementId", this.entitlementId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.entitlementId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public EntitlementInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new EntitlementInfo().createFromJson(json);
    }

    public static GetEntitlementBuilder builder() {
        return new GetEntitlementBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getEntitlementId() {
        return this.entitlementId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setEntitlementId(String entitlementId) {
        this.entitlementId = entitlementId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static class GetEntitlementBuilder {
        private String entitlementId;
        private String namespace;

        GetEntitlementBuilder() {
        }

        public GetEntitlementBuilder entitlementId(String entitlementId) {
            this.entitlementId = entitlementId;
            return this;
        }

        public GetEntitlementBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetEntitlement build() {
            return new GetEntitlement(this.entitlementId, this.namespace);
        }

        public String toString() {
            return "GetEntitlement.GetEntitlementBuilder(entitlementId=" + this.entitlementId + ", namespace=" + this.namespace + ")";
        }
    }
}

