/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.currency;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.CurrencyInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicListCurrencies
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/currencies";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String currencyType;

    @Deprecated
    public PublicListCurrencies(String namespace, String currencyType) {
        this.namespace = namespace;
        this.currencyType = currencyType;
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("currencyType", this.currencyType == null ? null : Arrays.asList(this.currencyType));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public List<CurrencyInfo> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<CurrencyInfo>>(){});
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("currencyType", "None");
        return result;
    }

    public static PublicListCurrenciesBuilder builder() {
        return new PublicListCurrenciesBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getCurrencyType() {
        return this.currencyType;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setCurrencyType(String currencyType) {
        this.currencyType = currencyType;
    }

    public static class PublicListCurrenciesBuilder {
        private String namespace;
        private String currencyType;

        public PublicListCurrenciesBuilder currencyType(String currencyType) {
            this.currencyType = currencyType;
            return this;
        }

        public PublicListCurrenciesBuilder currencyTypeFromEnum(CurrencyType currencyType) {
            this.currencyType = currencyType.toString();
            return this;
        }

        PublicListCurrenciesBuilder() {
        }

        public PublicListCurrenciesBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicListCurrencies build() {
            return new PublicListCurrencies(this.namespace, this.currencyType);
        }

        public String toString() {
            return "PublicListCurrencies.PublicListCurrenciesBuilder(namespace=" + this.namespace + ", currencyType=" + this.currencyType + ")";
        }
    }

    public static enum CurrencyType {
        REAL("REAL"),
        VIRTUAL("VIRTUAL");

        private String value;

        private CurrencyType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

