/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.clawback;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.IAPClawbackPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryIAPClawbackHistory
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/iap/clawback/histories";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String endTime;
    private String eventType;
    private String externalOrderId;
    private Integer limit;
    private Integer offset;
    private String startTime;
    private String status;
    private String userId;

    @Deprecated
    public QueryIAPClawbackHistory(String namespace, String endTime, String eventType, String externalOrderId, Integer limit, Integer offset, String startTime, String status, String userId) {
        this.namespace = namespace;
        this.endTime = endTime;
        this.eventType = eventType;
        this.externalOrderId = externalOrderId;
        this.limit = limit;
        this.offset = offset;
        this.startTime = startTime;
        this.status = status;
        this.userId = userId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("endTime", this.endTime == null ? null : Arrays.asList(this.endTime));
        queryParams.put("eventType", this.eventType == null ? null : Arrays.asList(this.eventType));
        queryParams.put("externalOrderId", this.externalOrderId == null ? null : Arrays.asList(this.externalOrderId));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("startTime", this.startTime == null ? null : Arrays.asList(this.startTime));
        queryParams.put("status", this.status == null ? null : Arrays.asList(this.status));
        queryParams.put("userId", this.userId == null ? null : Arrays.asList(this.userId));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public IAPClawbackPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new IAPClawbackPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("endTime", "None");
        result.put("eventType", "None");
        result.put("externalOrderId", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("startTime", "None");
        result.put("status", "None");
        result.put("userId", "None");
        return result;
    }

    public static QueryIAPClawbackHistoryBuilder builder() {
        return new QueryIAPClawbackHistoryBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getExternalOrderId() {
        return this.externalOrderId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getStatus() {
        return this.status;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public void setExternalOrderId(String externalOrderId) {
        this.externalOrderId = externalOrderId;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class QueryIAPClawbackHistoryBuilder {
        private String namespace;
        private String endTime;
        private String externalOrderId;
        private Integer limit;
        private Integer offset;
        private String startTime;
        private String userId;
        private String eventType;
        private String status;

        public QueryIAPClawbackHistoryBuilder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public QueryIAPClawbackHistoryBuilder eventTypeFromEnum(EventType eventType) {
            this.eventType = eventType.toString();
            return this;
        }

        public QueryIAPClawbackHistoryBuilder status(String status) {
            this.status = status;
            return this;
        }

        public QueryIAPClawbackHistoryBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        QueryIAPClawbackHistoryBuilder() {
        }

        public QueryIAPClawbackHistoryBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryIAPClawbackHistoryBuilder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public QueryIAPClawbackHistoryBuilder externalOrderId(String externalOrderId) {
            this.externalOrderId = externalOrderId;
            return this;
        }

        public QueryIAPClawbackHistoryBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryIAPClawbackHistoryBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryIAPClawbackHistoryBuilder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public QueryIAPClawbackHistoryBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public QueryIAPClawbackHistory build() {
            return new QueryIAPClawbackHistory(this.namespace, this.endTime, this.eventType, this.externalOrderId, this.limit, this.offset, this.startTime, this.status, this.userId);
        }

        public String toString() {
            return "QueryIAPClawbackHistory.QueryIAPClawbackHistoryBuilder(namespace=" + this.namespace + ", endTime=" + this.endTime + ", eventType=" + this.eventType + ", externalOrderId=" + this.externalOrderId + ", limit=" + this.limit + ", offset=" + this.offset + ", startTime=" + this.startTime + ", status=" + this.status + ", userId=" + this.userId + ")";
        }
    }

    public static enum Status {
        FAIL("FAIL"),
        IGNORED("IGNORED"),
        INIT("INIT"),
        SUCCESS("SUCCESS");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EventType {
        CHARGEBACK("CHARGEBACK"),
        CHARGEBACKREVERSED("CHARGEBACK_REVERSED"),
        OTHER("OTHER"),
        REFUND("REFUND");

        private String value;

        private EventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

