/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.category;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.CategoryInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetCategory
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/categories/{categoryPath}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String categoryPath;
    private String namespace;
    private String language;
    private String storeId;

    @Deprecated
    public PublicGetCategory(String categoryPath, String namespace, String language, String storeId) {
        this.categoryPath = categoryPath;
        this.namespace = namespace;
        this.language = language;
        this.storeId = storeId;
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.categoryPath != null) {
            pathParams.put("categoryPath", this.categoryPath);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("language", this.language == null ? null : Arrays.asList(this.language));
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.categoryPath == null) {
            return false;
        }
        return this.namespace != null;
    }

    public CategoryInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new CategoryInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("language", "None");
        result.put("storeId", "None");
        return result;
    }

    public static PublicGetCategoryBuilder builder() {
        return new PublicGetCategoryBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCategoryPath() {
        return this.categoryPath;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCategoryPath(String categoryPath) {
        this.categoryPath = categoryPath;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public static class PublicGetCategoryBuilder {
        private String categoryPath;
        private String namespace;
        private String language;
        private String storeId;

        PublicGetCategoryBuilder() {
        }

        public PublicGetCategoryBuilder categoryPath(String categoryPath) {
            this.categoryPath = categoryPath;
            return this;
        }

        public PublicGetCategoryBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGetCategoryBuilder language(String language) {
            this.language = language;
            return this;
        }

        public PublicGetCategoryBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public PublicGetCategory build() {
            return new PublicGetCategory(this.categoryPath, this.namespace, this.language, this.storeId);
        }

        public String toString() {
            return "PublicGetCategory.PublicGetCategoryBuilder(categoryPath=" + this.categoryPath + ", namespace=" + this.namespace + ", language=" + this.language + ", storeId=" + this.storeId + ")";
        }
    }
}

