/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.catalog_changes;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.CatalogChangeStatistics;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetStatistic
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/stores/{storeId}/catalogChanges/statistics";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String storeId;
    private String action;
    private String itemSku;
    private String itemType;
    private String type;
    private String updatedAtEnd;
    private String updatedAtStart;

    @Deprecated
    public GetStatistic(String namespace, String storeId, String action, String itemSku, String itemType, String type, String updatedAtEnd, String updatedAtStart) {
        this.namespace = namespace;
        this.storeId = storeId;
        this.action = action;
        this.itemSku = itemSku;
        this.itemType = itemType;
        this.type = type;
        this.updatedAtEnd = updatedAtEnd;
        this.updatedAtStart = updatedAtStart;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.storeId != null) {
            pathParams.put("storeId", this.storeId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("action", this.action == null ? null : Arrays.asList(this.action));
        queryParams.put("itemSku", this.itemSku == null ? null : Arrays.asList(this.itemSku));
        queryParams.put("itemType", this.itemType == null ? null : Arrays.asList(this.itemType));
        queryParams.put("type", this.type == null ? null : Arrays.asList(this.type));
        queryParams.put("updatedAtEnd", this.updatedAtEnd == null ? null : Arrays.asList(this.updatedAtEnd));
        queryParams.put("updatedAtStart", this.updatedAtStart == null ? null : Arrays.asList(this.updatedAtStart));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.storeId != null;
    }

    public CatalogChangeStatistics parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new CatalogChangeStatistics().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("action", "None");
        result.put("itemSku", "None");
        result.put("itemType", "None");
        result.put("type", "None");
        result.put("updatedAtEnd", "None");
        result.put("updatedAtStart", "None");
        return result;
    }

    public static GetStatisticBuilder builder() {
        return new GetStatisticBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getAction() {
        return this.action;
    }

    public String getItemSku() {
        return this.itemSku;
    }

    public String getItemType() {
        return this.itemType;
    }

    public String getType() {
        return this.type;
    }

    public String getUpdatedAtEnd() {
        return this.updatedAtEnd;
    }

    public String getUpdatedAtStart() {
        return this.updatedAtStart;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setItemSku(String itemSku) {
        this.itemSku = itemSku;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUpdatedAtEnd(String updatedAtEnd) {
        this.updatedAtEnd = updatedAtEnd;
    }

    public void setUpdatedAtStart(String updatedAtStart) {
        this.updatedAtStart = updatedAtStart;
    }

    public static class GetStatisticBuilder {
        private String namespace;
        private String storeId;
        private String itemSku;
        private String updatedAtEnd;
        private String updatedAtStart;
        private String action;
        private String itemType;
        private String type;

        public GetStatisticBuilder action(String action) {
            this.action = action;
            return this;
        }

        public GetStatisticBuilder actionFromEnum(Action action) {
            this.action = action.toString();
            return this;
        }

        public GetStatisticBuilder itemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        public GetStatisticBuilder itemTypeFromEnum(ItemType itemType) {
            this.itemType = itemType.toString();
            return this;
        }

        public GetStatisticBuilder type(String type) {
            this.type = type;
            return this;
        }

        public GetStatisticBuilder typeFromEnum(Type type) {
            this.type = type.toString();
            return this;
        }

        GetStatisticBuilder() {
        }

        public GetStatisticBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetStatisticBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public GetStatisticBuilder itemSku(String itemSku) {
            this.itemSku = itemSku;
            return this;
        }

        public GetStatisticBuilder updatedAtEnd(String updatedAtEnd) {
            this.updatedAtEnd = updatedAtEnd;
            return this;
        }

        public GetStatisticBuilder updatedAtStart(String updatedAtStart) {
            this.updatedAtStart = updatedAtStart;
            return this;
        }

        public GetStatistic build() {
            return new GetStatistic(this.namespace, this.storeId, this.action, this.itemSku, this.itemType, this.type, this.updatedAtEnd, this.updatedAtStart);
        }

        public String toString() {
            return "GetStatistic.GetStatisticBuilder(namespace=" + this.namespace + ", storeId=" + this.storeId + ", action=" + this.action + ", itemSku=" + this.itemSku + ", itemType=" + this.itemType + ", type=" + this.type + ", updatedAtEnd=" + this.updatedAtEnd + ", updatedAtStart=" + this.updatedAtStart + ")";
        }
    }

    public static enum Type {
        CATEGORY("CATEGORY"),
        ITEM("ITEM"),
        SECTION("SECTION"),
        STORE("STORE"),
        VIEW("VIEW");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ItemType {
        APP("APP"),
        BUNDLE("BUNDLE"),
        CODE("CODE"),
        COINS("COINS"),
        EXTENSION("EXTENSION"),
        INGAMEITEM("INGAMEITEM"),
        LOOTBOX("LOOTBOX"),
        MEDIA("MEDIA"),
        OPTIONBOX("OPTIONBOX"),
        SEASON("SEASON"),
        SUBSCRIPTION("SUBSCRIPTION");

        private String value;

        private ItemType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Action {
        CREATE("CREATE"),
        DELETE("DELETE"),
        UPDATE("UPDATE");

        private String value;

        private Action(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

