/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.campaign;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.CodeInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetCode
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/codes/{code}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String code;
    private String namespace;
    private Boolean redeemable;

    @Deprecated
    public GetCode(String code, String namespace, Boolean redeemable) {
        this.code = code;
        this.namespace = namespace;
        this.redeemable = redeemable;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.code != null) {
            pathParams.put("code", this.code);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("redeemable", this.redeemable == null ? null : Arrays.asList(String.valueOf(this.redeemable)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.code == null) {
            return false;
        }
        return this.namespace != null;
    }

    public CodeInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new CodeInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("redeemable", "None");
        return result;
    }

    public static GetCodeBuilder builder() {
        return new GetCodeBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCode() {
        return this.code;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getRedeemable() {
        return this.redeemable;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setRedeemable(Boolean redeemable) {
        this.redeemable = redeemable;
    }

    public static class GetCodeBuilder {
        private String code;
        private String namespace;
        private Boolean redeemable;

        GetCodeBuilder() {
        }

        public GetCodeBuilder code(String code) {
            this.code = code;
            return this;
        }

        public GetCodeBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetCodeBuilder redeemable(Boolean redeemable) {
            this.redeemable = redeemable;
            return this;
        }

        public GetCode build() {
            return new GetCode(this.code, this.namespace, this.redeemable);
        }

        public String toString() {
            return "GetCode.GetCodeBuilder(code=" + this.code + ", namespace=" + this.namespace + ", redeemable=" + this.redeemable + ")";
        }
    }
}

