/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.campaign;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.CodeInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class EnableCode
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/codes/{code}/enable";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String code;
    private String namespace;

    @Deprecated
    public EnableCode(String code, String namespace) {
        this.code = code;
        this.namespace = namespace;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.code != null) {
            pathParams.put("code", this.code);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.code == null) {
            return false;
        }
        return this.namespace != null;
    }

    public CodeInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new CodeInfo().createFromJson(json);
    }

    public static EnableCodeBuilder builder() {
        return new EnableCodeBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCode() {
        return this.code;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static class EnableCodeBuilder {
        private String code;
        private String namespace;

        EnableCodeBuilder() {
        }

        public EnableCodeBuilder code(String code) {
            this.code = code;
            return this;
        }

        public EnableCodeBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public EnableCode build() {
            return new EnableCode(this.code, this.namespace);
        }

        public String toString() {
            return "EnableCode.EnableCodeBuilder(code=" + this.code + ", namespace=" + this.namespace + ")";
        }
    }
}

