/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.campaign;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class Download
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/codes/campaigns/{campaignId}/codes.csv";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("text/csv");
    private String locationQuery = null;
    private String campaignId;
    private String namespace;
    private Integer batchNo;

    @Deprecated
    public Download(String campaignId, String namespace, Integer batchNo) {
        this.campaignId = campaignId;
        this.namespace = namespace;
        this.batchNo = batchNo;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.campaignId != null) {
            pathParams.put("campaignId", this.campaignId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("batchNo", this.batchNo == null ? null : Arrays.asList(String.valueOf(this.batchNo)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.campaignId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public InputStream parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        return payload;
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("batchNo", "None");
        return result;
    }

    public static DownloadBuilder builder() {
        return new DownloadBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getBatchNo() {
        return this.batchNo;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBatchNo(Integer batchNo) {
        this.batchNo = batchNo;
    }

    public static class DownloadBuilder {
        private String campaignId;
        private String namespace;
        private Integer batchNo;

        DownloadBuilder() {
        }

        public DownloadBuilder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public DownloadBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public DownloadBuilder batchNo(Integer batchNo) {
            this.batchNo = batchNo;
            return this;
        }

        public Download build() {
            return new Download(this.campaignId, this.namespace, this.batchNo);
        }

        public String toString() {
            return "Download.DownloadBuilder(campaignId=" + this.campaignId + ", namespace=" + this.namespace + ", batchNo=" + this.batchNo + ")";
        }
    }
}

