/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.campaign;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.CodeCreate;
import net.accelbyte.sdk.api.platform.models.CodeCreateResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class CreateCodes
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/codes/campaigns/{campaignId}";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList(new String[0]);
    private String locationQuery = null;
    private String campaignId;
    private String namespace;
    private CodeCreate body;

    @Deprecated
    public CreateCodes(String campaignId, String namespace, CodeCreate body) {
        this.campaignId = campaignId;
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.campaignId != null) {
            pathParams.put("campaignId", this.campaignId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public CodeCreate getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.campaignId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public CodeCreateResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 201) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new CodeCreateResult().createFromJson(json);
    }

    public static CreateCodesBuilder builder() {
        return new CreateCodesBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public CodeCreate getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(CodeCreate body) {
        this.body = body;
    }

    public static class CreateCodesBuilder {
        private String campaignId;
        private String namespace;
        private CodeCreate body;

        CreateCodesBuilder() {
        }

        public CreateCodesBuilder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public CreateCodesBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public CreateCodesBuilder body(CodeCreate body) {
            this.body = body;
            return this;
        }

        public CreateCodes build() {
            return new CreateCodes(this.campaignId, this.namespace, this.body);
        }

        public String toString() {
            return "CreateCodes.CreateCodesBuilder(campaignId=" + this.campaignId + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

