/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WalletRevocationConfig
extends Model {
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean enabled;
    @JsonProperty(value="strategy")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String strategy;

    @JsonIgnore
    public String getStrategy() {
        return this.strategy;
    }

    @JsonIgnore
    public Strategy getStrategyAsEnum() {
        return Strategy.valueOf(this.strategy);
    }

    @JsonIgnore
    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    @JsonIgnore
    public void setStrategyFromEnum(Strategy strategy) {
        this.strategy = strategy.toString();
    }

    @JsonIgnore
    public WalletRevocationConfig createFromJson(String json) throws JsonProcessingException {
        return (WalletRevocationConfig)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<WalletRevocationConfig> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<WalletRevocationConfig>>(){});
    }

    public static WalletRevocationConfigBuilder builder() {
        return new WalletRevocationConfigBuilder();
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Deprecated
    public WalletRevocationConfig(Boolean enabled, String strategy) {
        this.enabled = enabled;
        this.strategy = strategy;
    }

    public WalletRevocationConfig() {
    }

    public static class WalletRevocationConfigBuilder {
        private Boolean enabled;
        private String strategy;

        public WalletRevocationConfigBuilder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        public WalletRevocationConfigBuilder strategyFromEnum(Strategy strategy) {
            this.strategy = strategy.toString();
            return this;
        }

        WalletRevocationConfigBuilder() {
        }

        @JsonProperty(value="enabled")
        public WalletRevocationConfigBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public WalletRevocationConfig build() {
            return new WalletRevocationConfig(this.enabled, this.strategy);
        }

        public String toString() {
            return "WalletRevocationConfig.WalletRevocationConfigBuilder(enabled=" + this.enabled + ", strategy=" + this.strategy + ")";
        }
    }

    public static enum Strategy {
        ALWAYSREVOKE("ALWAYS_REVOKE"),
        CUSTOM("CUSTOM"),
        REVOKEORREPORT("REVOKE_OR_REPORT");

        private String value;

        private Strategy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

