/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.api.platform.models.AdditionalData;
import net.accelbyte.sdk.api.platform.models.CurrencySummary;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Transaction
extends Model {
    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private AdditionalData additionalData;
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer amount;
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private CurrencySummary currency;
    @JsonProperty(value="extMessage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String extMessage;
    @JsonProperty(value="extStatusCode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String extStatusCode;
    @JsonProperty(value="extTxId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String extTxId;
    @JsonProperty(value="merchantId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String merchantId;
    @JsonProperty(value="notified")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean notified;
    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String paymentMethod;
    @JsonProperty(value="paymentMethodFee")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer paymentMethodFee;
    @JsonProperty(value="paymentProviderFee")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer paymentProviderFee;
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String provider;
    @JsonProperty(value="salesTax")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer salesTax;
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String status;
    @JsonProperty(value="tax")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer tax;
    @JsonProperty(value="txEndTime")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String txEndTime;
    @JsonProperty(value="txId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String txId;
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String type;
    @JsonProperty(value="vat")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer vat;

    @JsonIgnore
    public String getProvider() {
        return this.provider;
    }

    @JsonIgnore
    public Provider getProviderAsEnum() {
        return Provider.valueOf(this.provider);
    }

    @JsonIgnore
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @JsonIgnore
    public void setProviderFromEnum(Provider provider) {
        this.provider = provider.toString();
    }

    @JsonIgnore
    public String getStatus() {
        return this.status;
    }

    @JsonIgnore
    public Status getStatusAsEnum() {
        return Status.valueOf(this.status);
    }

    @JsonIgnore
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonIgnore
    public void setStatusFromEnum(Status status) {
        this.status = status.toString();
    }

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public Type getTypeAsEnum() {
        return Type.valueOf(this.type);
    }

    @JsonIgnore
    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public void setTypeFromEnum(Type type) {
        this.type = type.toString();
    }

    @JsonIgnore
    public Transaction createFromJson(String json) throws JsonProcessingException {
        return (Transaction)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<Transaction> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<Transaction>>(){});
    }

    public static TransactionBuilder builder() {
        return new TransactionBuilder();
    }

    public AdditionalData getAdditionalData() {
        return this.additionalData;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public CurrencySummary getCurrency() {
        return this.currency;
    }

    public String getExtMessage() {
        return this.extMessage;
    }

    public String getExtStatusCode() {
        return this.extStatusCode;
    }

    public String getExtTxId() {
        return this.extTxId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public Boolean getNotified() {
        return this.notified;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public Integer getPaymentMethodFee() {
        return this.paymentMethodFee;
    }

    public Integer getPaymentProviderFee() {
        return this.paymentProviderFee;
    }

    public Integer getSalesTax() {
        return this.salesTax;
    }

    public Integer getTax() {
        return this.tax;
    }

    public String getTxEndTime() {
        return this.txEndTime;
    }

    public String getTxId() {
        return this.txId;
    }

    public Integer getVat() {
        return this.vat;
    }

    @JsonProperty(value="additionalData")
    public void setAdditionalData(AdditionalData additionalData) {
        this.additionalData = additionalData;
    }

    @JsonProperty(value="amount")
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @JsonProperty(value="currency")
    public void setCurrency(CurrencySummary currency) {
        this.currency = currency;
    }

    @JsonProperty(value="extMessage")
    public void setExtMessage(String extMessage) {
        this.extMessage = extMessage;
    }

    @JsonProperty(value="extStatusCode")
    public void setExtStatusCode(String extStatusCode) {
        this.extStatusCode = extStatusCode;
    }

    @JsonProperty(value="extTxId")
    public void setExtTxId(String extTxId) {
        this.extTxId = extTxId;
    }

    @JsonProperty(value="merchantId")
    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    @JsonProperty(value="notified")
    public void setNotified(Boolean notified) {
        this.notified = notified;
    }

    @JsonProperty(value="paymentMethod")
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @JsonProperty(value="paymentMethodFee")
    public void setPaymentMethodFee(Integer paymentMethodFee) {
        this.paymentMethodFee = paymentMethodFee;
    }

    @JsonProperty(value="paymentProviderFee")
    public void setPaymentProviderFee(Integer paymentProviderFee) {
        this.paymentProviderFee = paymentProviderFee;
    }

    @JsonProperty(value="salesTax")
    public void setSalesTax(Integer salesTax) {
        this.salesTax = salesTax;
    }

    @JsonProperty(value="tax")
    public void setTax(Integer tax) {
        this.tax = tax;
    }

    @JsonProperty(value="txEndTime")
    public void setTxEndTime(String txEndTime) {
        this.txEndTime = txEndTime;
    }

    @JsonProperty(value="txId")
    public void setTxId(String txId) {
        this.txId = txId;
    }

    @JsonProperty(value="vat")
    public void setVat(Integer vat) {
        this.vat = vat;
    }

    @Deprecated
    public Transaction(AdditionalData additionalData, Integer amount, CurrencySummary currency, String extMessage, String extStatusCode, String extTxId, String merchantId, Boolean notified, String paymentMethod, Integer paymentMethodFee, Integer paymentProviderFee, String provider, Integer salesTax, String status, Integer tax, String txEndTime, String txId, String type, Integer vat) {
        this.additionalData = additionalData;
        this.amount = amount;
        this.currency = currency;
        this.extMessage = extMessage;
        this.extStatusCode = extStatusCode;
        this.extTxId = extTxId;
        this.merchantId = merchantId;
        this.notified = notified;
        this.paymentMethod = paymentMethod;
        this.paymentMethodFee = paymentMethodFee;
        this.paymentProviderFee = paymentProviderFee;
        this.provider = provider;
        this.salesTax = salesTax;
        this.status = status;
        this.tax = tax;
        this.txEndTime = txEndTime;
        this.txId = txId;
        this.type = type;
        this.vat = vat;
    }

    public Transaction() {
    }

    public static class TransactionBuilder {
        private AdditionalData additionalData;
        private Integer amount;
        private CurrencySummary currency;
        private String extMessage;
        private String extStatusCode;
        private String extTxId;
        private String merchantId;
        private Boolean notified;
        private String paymentMethod;
        private Integer paymentMethodFee;
        private Integer paymentProviderFee;
        private Integer salesTax;
        private Integer tax;
        private String txEndTime;
        private String txId;
        private Integer vat;
        private String provider;
        private String status;
        private String type;

        public TransactionBuilder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public TransactionBuilder providerFromEnum(Provider provider) {
            this.provider = provider.toString();
            return this;
        }

        public TransactionBuilder status(String status) {
            this.status = status;
            return this;
        }

        public TransactionBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        public TransactionBuilder type(String type) {
            this.type = type;
            return this;
        }

        public TransactionBuilder typeFromEnum(Type type) {
            this.type = type.toString();
            return this;
        }

        TransactionBuilder() {
        }

        @JsonProperty(value="additionalData")
        public TransactionBuilder additionalData(AdditionalData additionalData) {
            this.additionalData = additionalData;
            return this;
        }

        @JsonProperty(value="amount")
        public TransactionBuilder amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        @JsonProperty(value="currency")
        public TransactionBuilder currency(CurrencySummary currency) {
            this.currency = currency;
            return this;
        }

        @JsonProperty(value="extMessage")
        public TransactionBuilder extMessage(String extMessage) {
            this.extMessage = extMessage;
            return this;
        }

        @JsonProperty(value="extStatusCode")
        public TransactionBuilder extStatusCode(String extStatusCode) {
            this.extStatusCode = extStatusCode;
            return this;
        }

        @JsonProperty(value="extTxId")
        public TransactionBuilder extTxId(String extTxId) {
            this.extTxId = extTxId;
            return this;
        }

        @JsonProperty(value="merchantId")
        public TransactionBuilder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        @JsonProperty(value="notified")
        public TransactionBuilder notified(Boolean notified) {
            this.notified = notified;
            return this;
        }

        @JsonProperty(value="paymentMethod")
        public TransactionBuilder paymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        @JsonProperty(value="paymentMethodFee")
        public TransactionBuilder paymentMethodFee(Integer paymentMethodFee) {
            this.paymentMethodFee = paymentMethodFee;
            return this;
        }

        @JsonProperty(value="paymentProviderFee")
        public TransactionBuilder paymentProviderFee(Integer paymentProviderFee) {
            this.paymentProviderFee = paymentProviderFee;
            return this;
        }

        @JsonProperty(value="salesTax")
        public TransactionBuilder salesTax(Integer salesTax) {
            this.salesTax = salesTax;
            return this;
        }

        @JsonProperty(value="tax")
        public TransactionBuilder tax(Integer tax) {
            this.tax = tax;
            return this;
        }

        @JsonProperty(value="txEndTime")
        public TransactionBuilder txEndTime(String txEndTime) {
            this.txEndTime = txEndTime;
            return this;
        }

        @JsonProperty(value="txId")
        public TransactionBuilder txId(String txId) {
            this.txId = txId;
            return this;
        }

        @JsonProperty(value="vat")
        public TransactionBuilder vat(Integer vat) {
            this.vat = vat;
            return this;
        }

        public Transaction build() {
            return new Transaction(this.additionalData, this.amount, this.currency, this.extMessage, this.extStatusCode, this.extTxId, this.merchantId, this.notified, this.paymentMethod, this.paymentMethodFee, this.paymentProviderFee, this.provider, this.salesTax, this.status, this.tax, this.txEndTime, this.txId, this.type, this.vat);
        }

        public String toString() {
            return "Transaction.TransactionBuilder(additionalData=" + (Object)((Object)this.additionalData) + ", amount=" + this.amount + ", currency=" + (Object)((Object)this.currency) + ", extMessage=" + this.extMessage + ", extStatusCode=" + this.extStatusCode + ", extTxId=" + this.extTxId + ", merchantId=" + this.merchantId + ", notified=" + this.notified + ", paymentMethod=" + this.paymentMethod + ", paymentMethodFee=" + this.paymentMethodFee + ", paymentProviderFee=" + this.paymentProviderFee + ", provider=" + this.provider + ", salesTax=" + this.salesTax + ", status=" + this.status + ", tax=" + this.tax + ", txEndTime=" + this.txEndTime + ", txId=" + this.txId + ", type=" + this.type + ", vat=" + this.vat + ")";
        }
    }

    public static enum Type {
        AUTHORISATION("AUTHORISATION"),
        CHARGE("CHARGE"),
        CHARGEBACK("CHARGEBACK"),
        CHARGEBACKREVERSED("CHARGEBACK_REVERSED"),
        CHARGEFAILED("CHARGE_FAILED"),
        NOTIFICATIONOFCHARGEBACK("NOTIFICATION_OF_CHARGEBACK"),
        REFUND("REFUND"),
        REFUNDFAILED("REFUND_FAILED"),
        REQUESTFORINFORMATION("REQUEST_FOR_INFORMATION");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Status {
        FAILED("FAILED"),
        FINISHED("FINISHED");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Provider {
        ADYEN("ADYEN"),
        ALIPAY("ALIPAY"),
        CHECKOUT("CHECKOUT"),
        PAYPAL("PAYPAL"),
        STRIPE("STRIPE"),
        WALLET("WALLET"),
        WXPAY("WXPAY"),
        XSOLLA("XSOLLA");

        private String value;

        private Provider(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

