/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StripeConfig
extends Model {
    @JsonProperty(value="allowedPaymentMethodTypes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> allowedPaymentMethodTypes;
    @JsonProperty(value="publishableKey")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String publishableKey;
    @JsonProperty(value="secretKey")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String secretKey;
    @JsonProperty(value="webhookSecret")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String webhookSecret;

    @JsonIgnore
    public StripeConfig createFromJson(String json) throws JsonProcessingException {
        return (StripeConfig)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<StripeConfig> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<StripeConfig>>(){});
    }

    public static StripeConfigBuilder builder() {
        return new StripeConfigBuilder();
    }

    public List<String> getAllowedPaymentMethodTypes() {
        return this.allowedPaymentMethodTypes;
    }

    public String getPublishableKey() {
        return this.publishableKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getWebhookSecret() {
        return this.webhookSecret;
    }

    @JsonProperty(value="allowedPaymentMethodTypes")
    public void setAllowedPaymentMethodTypes(List<String> allowedPaymentMethodTypes) {
        this.allowedPaymentMethodTypes = allowedPaymentMethodTypes;
    }

    @JsonProperty(value="publishableKey")
    public void setPublishableKey(String publishableKey) {
        this.publishableKey = publishableKey;
    }

    @JsonProperty(value="secretKey")
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @JsonProperty(value="webhookSecret")
    public void setWebhookSecret(String webhookSecret) {
        this.webhookSecret = webhookSecret;
    }

    @Deprecated
    public StripeConfig(List<String> allowedPaymentMethodTypes, String publishableKey, String secretKey, String webhookSecret) {
        this.allowedPaymentMethodTypes = allowedPaymentMethodTypes;
        this.publishableKey = publishableKey;
        this.secretKey = secretKey;
        this.webhookSecret = webhookSecret;
    }

    public StripeConfig() {
    }

    public static class StripeConfigBuilder {
        private List<String> allowedPaymentMethodTypes;
        private String publishableKey;
        private String secretKey;
        private String webhookSecret;

        StripeConfigBuilder() {
        }

        @JsonProperty(value="allowedPaymentMethodTypes")
        public StripeConfigBuilder allowedPaymentMethodTypes(List<String> allowedPaymentMethodTypes) {
            this.allowedPaymentMethodTypes = allowedPaymentMethodTypes;
            return this;
        }

        @JsonProperty(value="publishableKey")
        public StripeConfigBuilder publishableKey(String publishableKey) {
            this.publishableKey = publishableKey;
            return this;
        }

        @JsonProperty(value="secretKey")
        public StripeConfigBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        @JsonProperty(value="webhookSecret")
        public StripeConfigBuilder webhookSecret(String webhookSecret) {
            this.webhookSecret = webhookSecret;
            return this;
        }

        public StripeConfig build() {
            return new StripeConfig(this.allowedPaymentMethodTypes, this.publishableKey, this.secretKey, this.webhookSecret);
        }

        public String toString() {
            return "StripeConfig.StripeConfigBuilder(allowedPaymentMethodTypes=" + this.allowedPaymentMethodTypes + ", publishableKey=" + this.publishableKey + ", secretKey=" + this.secretKey + ", webhookSecret=" + this.webhookSecret + ")";
        }
    }
}

