/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SteamSyncRequest
extends Model {
    @JsonProperty(value="appId")
    private String appId;
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String currencyCode;
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String language;
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Float price;
    @JsonProperty(value="productId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String productId;
    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String region;
    @JsonProperty(value="steamId")
    private String steamId;

    @JsonIgnore
    public SteamSyncRequest createFromJson(String json) throws JsonProcessingException {
        return (SteamSyncRequest)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<SteamSyncRequest> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<SteamSyncRequest>>(){});
    }

    public static SteamSyncRequestBuilder builder() {
        return new SteamSyncRequestBuilder();
    }

    public String getAppId() {
        return this.appId;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getLanguage() {
        return this.language;
    }

    public Float getPrice() {
        return this.price;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSteamId() {
        return this.steamId;
    }

    @JsonProperty(value="appId")
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @JsonProperty(value="currencyCode")
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    @JsonProperty(value="price")
    public void setPrice(Float price) {
        this.price = price;
    }

    @JsonProperty(value="productId")
    public void setProductId(String productId) {
        this.productId = productId;
    }

    @JsonProperty(value="region")
    public void setRegion(String region) {
        this.region = region;
    }

    @JsonProperty(value="steamId")
    public void setSteamId(String steamId) {
        this.steamId = steamId;
    }

    @Deprecated
    public SteamSyncRequest(String appId, String currencyCode, String language, Float price, String productId, String region, String steamId) {
        this.appId = appId;
        this.currencyCode = currencyCode;
        this.language = language;
        this.price = price;
        this.productId = productId;
        this.region = region;
        this.steamId = steamId;
    }

    public SteamSyncRequest() {
    }

    public static class SteamSyncRequestBuilder {
        private String appId;
        private String currencyCode;
        private String language;
        private Float price;
        private String productId;
        private String region;
        private String steamId;

        SteamSyncRequestBuilder() {
        }

        @JsonProperty(value="appId")
        public SteamSyncRequestBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        @JsonProperty(value="currencyCode")
        public SteamSyncRequestBuilder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @JsonProperty(value="language")
        public SteamSyncRequestBuilder language(String language) {
            this.language = language;
            return this;
        }

        @JsonProperty(value="price")
        public SteamSyncRequestBuilder price(Float price) {
            this.price = price;
            return this;
        }

        @JsonProperty(value="productId")
        public SteamSyncRequestBuilder productId(String productId) {
            this.productId = productId;
            return this;
        }

        @JsonProperty(value="region")
        public SteamSyncRequestBuilder region(String region) {
            this.region = region;
            return this;
        }

        @JsonProperty(value="steamId")
        public SteamSyncRequestBuilder steamId(String steamId) {
            this.steamId = steamId;
            return this;
        }

        public SteamSyncRequest build() {
            return new SteamSyncRequest(this.appId, this.currencyCode, this.language, this.price, this.productId, this.region, this.steamId);
        }

        public String toString() {
            return "SteamSyncRequest.SteamSyncRequestBuilder(appId=" + this.appId + ", currencyCode=" + this.currencyCode + ", language=" + this.language + ", price=" + this.price + ", productId=" + this.productId + ", region=" + this.region + ", steamId=" + this.steamId + ")";
        }
    }
}

