/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.PlatformReward;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RewardsRequest
extends Model {
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, ?> metadata;
    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String origin;
    @JsonProperty(value="rewards")
    private List<PlatformReward> rewards;
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String source;
    @JsonProperty(value="transactionId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String transactionId;

    @JsonIgnore
    public String getOrigin() {
        return this.origin;
    }

    @JsonIgnore
    public Origin getOriginAsEnum() {
        return Origin.valueOf(this.origin);
    }

    @JsonIgnore
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    @JsonIgnore
    public void setOriginFromEnum(Origin origin) {
        this.origin = origin.toString();
    }

    @JsonIgnore
    public String getSource() {
        return this.source;
    }

    @JsonIgnore
    public Source getSourceAsEnum() {
        return Source.valueOf(this.source);
    }

    @JsonIgnore
    public void setSource(String source) {
        this.source = source;
    }

    @JsonIgnore
    public void setSourceFromEnum(Source source) {
        this.source = source.toString();
    }

    @JsonIgnore
    public RewardsRequest createFromJson(String json) throws JsonProcessingException {
        return (RewardsRequest)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<RewardsRequest> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<RewardsRequest>>(){});
    }

    public static RewardsRequestBuilder builder() {
        return new RewardsRequestBuilder();
    }

    public Map<String, ?> getMetadata() {
        return this.metadata;
    }

    public List<PlatformReward> getRewards() {
        return this.rewards;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, ?> metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="rewards")
    public void setRewards(List<PlatformReward> rewards) {
        this.rewards = rewards;
    }

    @JsonProperty(value="transactionId")
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Deprecated
    public RewardsRequest(Map<String, ?> metadata, String origin, List<PlatformReward> rewards, String source, String transactionId) {
        this.metadata = metadata;
        this.origin = origin;
        this.rewards = rewards;
        this.source = source;
        this.transactionId = transactionId;
    }

    public RewardsRequest() {
    }

    public static class RewardsRequestBuilder {
        private Map<String, ?> metadata;
        private List<PlatformReward> rewards;
        private String transactionId;
        private String origin;
        private String source;

        public RewardsRequestBuilder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public RewardsRequestBuilder originFromEnum(Origin origin) {
            this.origin = origin.toString();
            return this;
        }

        public RewardsRequestBuilder source(String source) {
            this.source = source;
            return this;
        }

        public RewardsRequestBuilder sourceFromEnum(Source source) {
            this.source = source.toString();
            return this;
        }

        RewardsRequestBuilder() {
        }

        @JsonProperty(value="metadata")
        public RewardsRequestBuilder metadata(Map<String, ?> metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="rewards")
        public RewardsRequestBuilder rewards(List<PlatformReward> rewards) {
            this.rewards = rewards;
            return this;
        }

        @JsonProperty(value="transactionId")
        public RewardsRequestBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public RewardsRequest build() {
            return new RewardsRequest(this.metadata, this.origin, this.rewards, this.source, this.transactionId);
        }

        public String toString() {
            return "RewardsRequest.RewardsRequestBuilder(metadata=" + this.metadata + ", origin=" + this.origin + ", rewards=" + this.rewards + ", source=" + this.source + ", transactionId=" + this.transactionId + ")";
        }
    }

    public static enum Source {
        ACHIEVEMENT("ACHIEVEMENT"),
        CONSUMEENTITLEMENT("CONSUME_ENTITLEMENT"),
        DLC("DLC"),
        EXPIRATION("EXPIRATION"),
        GIFT("GIFT"),
        IAP("IAP"),
        IAPCHARGEBACKREVERSED("IAP_CHARGEBACK_REVERSED"),
        ORDERREVOCATION("ORDER_REVOCATION"),
        OTHER("OTHER"),
        PAYMENT("PAYMENT"),
        PROMOTION("PROMOTION"),
        PURCHASE("PURCHASE"),
        REDEEMCODE("REDEEM_CODE"),
        REFERRALBONUS("REFERRAL_BONUS"),
        REWARD("REWARD"),
        SELLBACK("SELL_BACK");

        private String value;

        private Source(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Origin {
        Epic("Epic"),
        GooglePlay("GooglePlay"),
        IOS("IOS"),
        Nintendo("Nintendo"),
        Oculus("Oculus"),
        Other("Other"),
        Playstation("Playstation"),
        Steam("Steam"),
        System("System"),
        Twitch("Twitch"),
        Xbox("Xbox");

        private String value;

        private Origin(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

