/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.RegionDataItem;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RegionDataChange
extends Model {
    @JsonProperty(value="itemIdentities")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> itemIdentities;
    @JsonProperty(value="itemIdentityType")
    private String itemIdentityType;
    @JsonProperty(value="regionData")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, List<RegionDataItem>> regionData;

    @JsonIgnore
    public String getItemIdentityType() {
        return this.itemIdentityType;
    }

    @JsonIgnore
    public ItemIdentityType getItemIdentityTypeAsEnum() {
        return ItemIdentityType.valueOf(this.itemIdentityType);
    }

    @JsonIgnore
    public void setItemIdentityType(String itemIdentityType) {
        this.itemIdentityType = itemIdentityType;
    }

    @JsonIgnore
    public void setItemIdentityTypeFromEnum(ItemIdentityType itemIdentityType) {
        this.itemIdentityType = itemIdentityType.toString();
    }

    @JsonIgnore
    public RegionDataChange createFromJson(String json) throws JsonProcessingException {
        return (RegionDataChange)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<RegionDataChange> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<RegionDataChange>>(){});
    }

    public static RegionDataChangeBuilder builder() {
        return new RegionDataChangeBuilder();
    }

    public List<String> getItemIdentities() {
        return this.itemIdentities;
    }

    public Map<String, List<RegionDataItem>> getRegionData() {
        return this.regionData;
    }

    @JsonProperty(value="itemIdentities")
    public void setItemIdentities(List<String> itemIdentities) {
        this.itemIdentities = itemIdentities;
    }

    @JsonProperty(value="regionData")
    public void setRegionData(Map<String, List<RegionDataItem>> regionData) {
        this.regionData = regionData;
    }

    @Deprecated
    public RegionDataChange(List<String> itemIdentities, String itemIdentityType, Map<String, List<RegionDataItem>> regionData) {
        this.itemIdentities = itemIdentities;
        this.itemIdentityType = itemIdentityType;
        this.regionData = regionData;
    }

    public RegionDataChange() {
    }

    public static class RegionDataChangeBuilder {
        private List<String> itemIdentities;
        private Map<String, List<RegionDataItem>> regionData;
        private String itemIdentityType;

        public RegionDataChangeBuilder itemIdentityType(String itemIdentityType) {
            this.itemIdentityType = itemIdentityType;
            return this;
        }

        public RegionDataChangeBuilder itemIdentityTypeFromEnum(ItemIdentityType itemIdentityType) {
            this.itemIdentityType = itemIdentityType.toString();
            return this;
        }

        RegionDataChangeBuilder() {
        }

        @JsonProperty(value="itemIdentities")
        public RegionDataChangeBuilder itemIdentities(List<String> itemIdentities) {
            this.itemIdentities = itemIdentities;
            return this;
        }

        @JsonProperty(value="regionData")
        public RegionDataChangeBuilder regionData(Map<String, List<RegionDataItem>> regionData) {
            this.regionData = regionData;
            return this;
        }

        public RegionDataChange build() {
            return new RegionDataChange(this.itemIdentities, this.itemIdentityType, this.regionData);
        }

        public String toString() {
            return "RegionDataChange.RegionDataChangeBuilder(itemIdentities=" + this.itemIdentities + ", itemIdentityType=" + this.itemIdentityType + ", regionData=" + this.regionData + ")";
        }
    }

    public static enum ItemIdentityType {
        ITEMID("ITEM_ID"),
        ITEMSKU("ITEM_SKU");

        private String value;

        private ItemIdentityType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

