/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Recurring
extends Model {
    @JsonProperty(value="cycle")
    private String cycle;
    @JsonProperty(value="fixedFreeDays")
    private Integer fixedFreeDays;
    @JsonProperty(value="fixedTrialCycles")
    private Integer fixedTrialCycles;
    @JsonProperty(value="graceDays")
    private Integer graceDays;

    @JsonIgnore
    public String getCycle() {
        return this.cycle;
    }

    @JsonIgnore
    public Cycle getCycleAsEnum() {
        return Cycle.valueOf(this.cycle);
    }

    @JsonIgnore
    public void setCycle(String cycle) {
        this.cycle = cycle;
    }

    @JsonIgnore
    public void setCycleFromEnum(Cycle cycle) {
        this.cycle = cycle.toString();
    }

    @JsonIgnore
    public Recurring createFromJson(String json) throws JsonProcessingException {
        return (Recurring)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<Recurring> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<Recurring>>(){});
    }

    public static RecurringBuilder builder() {
        return new RecurringBuilder();
    }

    public Integer getFixedFreeDays() {
        return this.fixedFreeDays;
    }

    public Integer getFixedTrialCycles() {
        return this.fixedTrialCycles;
    }

    public Integer getGraceDays() {
        return this.graceDays;
    }

    @JsonProperty(value="fixedFreeDays")
    public void setFixedFreeDays(Integer fixedFreeDays) {
        this.fixedFreeDays = fixedFreeDays;
    }

    @JsonProperty(value="fixedTrialCycles")
    public void setFixedTrialCycles(Integer fixedTrialCycles) {
        this.fixedTrialCycles = fixedTrialCycles;
    }

    @JsonProperty(value="graceDays")
    public void setGraceDays(Integer graceDays) {
        this.graceDays = graceDays;
    }

    @Deprecated
    public Recurring(String cycle, Integer fixedFreeDays, Integer fixedTrialCycles, Integer graceDays) {
        this.cycle = cycle;
        this.fixedFreeDays = fixedFreeDays;
        this.fixedTrialCycles = fixedTrialCycles;
        this.graceDays = graceDays;
    }

    public Recurring() {
    }

    public static class RecurringBuilder {
        private Integer fixedFreeDays;
        private Integer fixedTrialCycles;
        private Integer graceDays;
        private String cycle;

        public RecurringBuilder cycle(String cycle) {
            this.cycle = cycle;
            return this;
        }

        public RecurringBuilder cycleFromEnum(Cycle cycle) {
            this.cycle = cycle.toString();
            return this;
        }

        RecurringBuilder() {
        }

        @JsonProperty(value="fixedFreeDays")
        public RecurringBuilder fixedFreeDays(Integer fixedFreeDays) {
            this.fixedFreeDays = fixedFreeDays;
            return this;
        }

        @JsonProperty(value="fixedTrialCycles")
        public RecurringBuilder fixedTrialCycles(Integer fixedTrialCycles) {
            this.fixedTrialCycles = fixedTrialCycles;
            return this;
        }

        @JsonProperty(value="graceDays")
        public RecurringBuilder graceDays(Integer graceDays) {
            this.graceDays = graceDays;
            return this;
        }

        public Recurring build() {
            return new Recurring(this.cycle, this.fixedFreeDays, this.fixedTrialCycles, this.graceDays);
        }

        public String toString() {
            return "Recurring.RecurringBuilder(cycle=" + this.cycle + ", fixedFreeDays=" + this.fixedFreeDays + ", fixedTrialCycles=" + this.fixedTrialCycles + ", graceDays=" + this.graceDays + ")";
        }
    }

    public static enum Cycle {
        MONTHLY("MONTHLY"),
        QUARTERLY("QUARTERLY"),
        WEEKLY("WEEKLY"),
        YEARLY("YEARLY");

        private String value;

        private Cycle(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

