/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.api.platform.models.WalletInfo;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PlatformWallet
extends Model {
    @JsonProperty(value="balance")
    private Integer balance;
    @JsonProperty(value="currencyCode")
    private String currencyCode;
    @JsonProperty(value="currencySymbol")
    private String currencySymbol;
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String id;
    @JsonProperty(value="namespace")
    private String namespace;
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String status;
    @JsonProperty(value="userId")
    private String userId;
    @JsonProperty(value="walletInfos")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<WalletInfo> walletInfos;
    @JsonProperty(value="walletStatus")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String walletStatus;

    @JsonIgnore
    public String getStatus() {
        return this.status;
    }

    @JsonIgnore
    public Status getStatusAsEnum() {
        return Status.valueOf(this.status);
    }

    @JsonIgnore
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonIgnore
    public void setStatusFromEnum(Status status) {
        this.status = status.toString();
    }

    @JsonIgnore
    public String getWalletStatus() {
        return this.walletStatus;
    }

    @JsonIgnore
    public WalletStatus getWalletStatusAsEnum() {
        return WalletStatus.valueOf(this.walletStatus);
    }

    @JsonIgnore
    public void setWalletStatus(String walletStatus) {
        this.walletStatus = walletStatus;
    }

    @JsonIgnore
    public void setWalletStatusFromEnum(WalletStatus walletStatus) {
        this.walletStatus = walletStatus.toString();
    }

    @JsonIgnore
    public PlatformWallet createFromJson(String json) throws JsonProcessingException {
        return (PlatformWallet)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<PlatformWallet> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PlatformWallet>>(){});
    }

    public static PlatformWalletBuilder builder() {
        return new PlatformWalletBuilder();
    }

    public Integer getBalance() {
        return this.balance;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public String getId() {
        return this.id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public List<WalletInfo> getWalletInfos() {
        return this.walletInfos;
    }

    @JsonProperty(value="balance")
    public void setBalance(Integer balance) {
        this.balance = balance;
    }

    @JsonProperty(value="currencyCode")
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @JsonProperty(value="currencySymbol")
    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @JsonProperty(value="walletInfos")
    public void setWalletInfos(List<WalletInfo> walletInfos) {
        this.walletInfos = walletInfos;
    }

    @Deprecated
    public PlatformWallet(Integer balance, String currencyCode, String currencySymbol, String id, String namespace, String status, String userId, List<WalletInfo> walletInfos, String walletStatus) {
        this.balance = balance;
        this.currencyCode = currencyCode;
        this.currencySymbol = currencySymbol;
        this.id = id;
        this.namespace = namespace;
        this.status = status;
        this.userId = userId;
        this.walletInfos = walletInfos;
        this.walletStatus = walletStatus;
    }

    public PlatformWallet() {
    }

    public static class PlatformWalletBuilder {
        private Integer balance;
        private String currencyCode;
        private String currencySymbol;
        private String id;
        private String namespace;
        private String userId;
        private List<WalletInfo> walletInfos;
        private String status;
        private String walletStatus;

        public PlatformWalletBuilder status(String status) {
            this.status = status;
            return this;
        }

        public PlatformWalletBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        public PlatformWalletBuilder walletStatus(String walletStatus) {
            this.walletStatus = walletStatus;
            return this;
        }

        public PlatformWalletBuilder walletStatusFromEnum(WalletStatus walletStatus) {
            this.walletStatus = walletStatus.toString();
            return this;
        }

        PlatformWalletBuilder() {
        }

        @JsonProperty(value="balance")
        public PlatformWalletBuilder balance(Integer balance) {
            this.balance = balance;
            return this;
        }

        @JsonProperty(value="currencyCode")
        public PlatformWalletBuilder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @JsonProperty(value="currencySymbol")
        public PlatformWalletBuilder currencySymbol(String currencySymbol) {
            this.currencySymbol = currencySymbol;
            return this;
        }

        @JsonProperty(value="id")
        public PlatformWalletBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="namespace")
        public PlatformWalletBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @JsonProperty(value="userId")
        public PlatformWalletBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="walletInfos")
        public PlatformWalletBuilder walletInfos(List<WalletInfo> walletInfos) {
            this.walletInfos = walletInfos;
            return this;
        }

        public PlatformWallet build() {
            return new PlatformWallet(this.balance, this.currencyCode, this.currencySymbol, this.id, this.namespace, this.status, this.userId, this.walletInfos, this.walletStatus);
        }

        public String toString() {
            return "PlatformWallet.PlatformWalletBuilder(balance=" + this.balance + ", currencyCode=" + this.currencyCode + ", currencySymbol=" + this.currencySymbol + ", id=" + this.id + ", namespace=" + this.namespace + ", status=" + this.status + ", userId=" + this.userId + ", walletInfos=" + this.walletInfos + ", walletStatus=" + this.walletStatus + ")";
        }
    }

    public static enum WalletStatus {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE");

        private String value;

        private WalletStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Status {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

