/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.api.platform.models.PlatformRewardCurrency;
import net.accelbyte.sdk.api.platform.models.PlatformRewardItem;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PlatformReward
extends Model {
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private PlatformRewardCurrency currency;
    @JsonProperty(value="item")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private PlatformRewardItem item;
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer quantity;
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String type;

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public Type getTypeAsEnum() {
        return Type.valueOf(this.type);
    }

    @JsonIgnore
    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public void setTypeFromEnum(Type type) {
        this.type = type.toString();
    }

    @JsonIgnore
    public PlatformReward createFromJson(String json) throws JsonProcessingException {
        return (PlatformReward)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<PlatformReward> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PlatformReward>>(){});
    }

    public static PlatformRewardBuilder builder() {
        return new PlatformRewardBuilder();
    }

    public PlatformRewardCurrency getCurrency() {
        return this.currency;
    }

    public PlatformRewardItem getItem() {
        return this.item;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="currency")
    public void setCurrency(PlatformRewardCurrency currency) {
        this.currency = currency;
    }

    @JsonProperty(value="item")
    public void setItem(PlatformRewardItem item) {
        this.item = item;
    }

    @JsonProperty(value="quantity")
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @Deprecated
    public PlatformReward(PlatformRewardCurrency currency, PlatformRewardItem item, Integer quantity, String type) {
        this.currency = currency;
        this.item = item;
        this.quantity = quantity;
        this.type = type;
    }

    public PlatformReward() {
    }

    public static class PlatformRewardBuilder {
        private PlatformRewardCurrency currency;
        private PlatformRewardItem item;
        private Integer quantity;
        private String type;

        public PlatformRewardBuilder type(String type) {
            this.type = type;
            return this;
        }

        public PlatformRewardBuilder typeFromEnum(Type type) {
            this.type = type.toString();
            return this;
        }

        PlatformRewardBuilder() {
        }

        @JsonProperty(value="currency")
        public PlatformRewardBuilder currency(PlatformRewardCurrency currency) {
            this.currency = currency;
            return this;
        }

        @JsonProperty(value="item")
        public PlatformRewardBuilder item(PlatformRewardItem item) {
            this.item = item;
            return this;
        }

        @JsonProperty(value="quantity")
        public PlatformRewardBuilder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public PlatformReward build() {
            return new PlatformReward(this.currency, this.item, this.quantity, this.type);
        }

        public String toString() {
            return "PlatformReward.PlatformRewardBuilder(currency=" + (Object)((Object)this.currency) + ", item=" + (Object)((Object)this.item) + ", quantity=" + this.quantity + ", type=" + this.type + ")";
        }
    }

    public static enum Type {
        CURRENCY("CURRENCY"),
        ITEM("ITEM");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

