/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentUrlCreate
extends Model {
    @JsonProperty(value="paymentOrderNo")
    private String paymentOrderNo;
    @JsonProperty(value="paymentProvider")
    private String paymentProvider;
    @JsonProperty(value="returnUrl")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String returnUrl;
    @JsonProperty(value="ui")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String ui;
    @JsonProperty(value="zipCode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String zipCode;

    @JsonIgnore
    public String getPaymentProvider() {
        return this.paymentProvider;
    }

    @JsonIgnore
    public PaymentProvider getPaymentProviderAsEnum() {
        return PaymentProvider.valueOf(this.paymentProvider);
    }

    @JsonIgnore
    public void setPaymentProvider(String paymentProvider) {
        this.paymentProvider = paymentProvider;
    }

    @JsonIgnore
    public void setPaymentProviderFromEnum(PaymentProvider paymentProvider) {
        this.paymentProvider = paymentProvider.toString();
    }

    @JsonIgnore
    public PaymentUrlCreate createFromJson(String json) throws JsonProcessingException {
        return (PaymentUrlCreate)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<PaymentUrlCreate> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PaymentUrlCreate>>(){});
    }

    public static PaymentUrlCreateBuilder builder() {
        return new PaymentUrlCreateBuilder();
    }

    public String getPaymentOrderNo() {
        return this.paymentOrderNo;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public String getUi() {
        return this.ui;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    @JsonProperty(value="paymentOrderNo")
    public void setPaymentOrderNo(String paymentOrderNo) {
        this.paymentOrderNo = paymentOrderNo;
    }

    @JsonProperty(value="returnUrl")
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @JsonProperty(value="ui")
    public void setUi(String ui) {
        this.ui = ui;
    }

    @JsonProperty(value="zipCode")
    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    @Deprecated
    public PaymentUrlCreate(String paymentOrderNo, String paymentProvider, String returnUrl, String ui, String zipCode) {
        this.paymentOrderNo = paymentOrderNo;
        this.paymentProvider = paymentProvider;
        this.returnUrl = returnUrl;
        this.ui = ui;
        this.zipCode = zipCode;
    }

    public PaymentUrlCreate() {
    }

    public static class PaymentUrlCreateBuilder {
        private String paymentOrderNo;
        private String returnUrl;
        private String ui;
        private String zipCode;
        private String paymentProvider;

        public PaymentUrlCreateBuilder paymentProvider(String paymentProvider) {
            this.paymentProvider = paymentProvider;
            return this;
        }

        public PaymentUrlCreateBuilder paymentProviderFromEnum(PaymentProvider paymentProvider) {
            this.paymentProvider = paymentProvider.toString();
            return this;
        }

        PaymentUrlCreateBuilder() {
        }

        @JsonProperty(value="paymentOrderNo")
        public PaymentUrlCreateBuilder paymentOrderNo(String paymentOrderNo) {
            this.paymentOrderNo = paymentOrderNo;
            return this;
        }

        @JsonProperty(value="returnUrl")
        public PaymentUrlCreateBuilder returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @JsonProperty(value="ui")
        public PaymentUrlCreateBuilder ui(String ui) {
            this.ui = ui;
            return this;
        }

        @JsonProperty(value="zipCode")
        public PaymentUrlCreateBuilder zipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public PaymentUrlCreate build() {
            return new PaymentUrlCreate(this.paymentOrderNo, this.paymentProvider, this.returnUrl, this.ui, this.zipCode);
        }

        public String toString() {
            return "PaymentUrlCreate.PaymentUrlCreateBuilder(paymentOrderNo=" + this.paymentOrderNo + ", paymentProvider=" + this.paymentProvider + ", returnUrl=" + this.returnUrl + ", ui=" + this.ui + ", zipCode=" + this.zipCode + ")";
        }
    }

    public static enum PaymentProvider {
        ADYEN("ADYEN"),
        ALIPAY("ALIPAY"),
        CHECKOUT("CHECKOUT"),
        PAYPAL("PAYPAL"),
        STRIPE("STRIPE"),
        WALLET("WALLET"),
        WXPAY("WXPAY"),
        XSOLLA("XSOLLA");

        private String value;

        private PaymentProvider(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

