/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentRequest
extends Model {
    @JsonProperty(value="amount")
    private Integer amount;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, ?> metadata;
    @JsonProperty(value="walletPlatform")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String walletPlatform;

    @JsonIgnore
    public String getWalletPlatform() {
        return this.walletPlatform;
    }

    @JsonIgnore
    public WalletPlatform getWalletPlatformAsEnum() {
        return WalletPlatform.valueOf(this.walletPlatform);
    }

    @JsonIgnore
    public void setWalletPlatform(String walletPlatform) {
        this.walletPlatform = walletPlatform;
    }

    @JsonIgnore
    public void setWalletPlatformFromEnum(WalletPlatform walletPlatform) {
        this.walletPlatform = walletPlatform.toString();
    }

    @JsonIgnore
    public PaymentRequest createFromJson(String json) throws JsonProcessingException {
        return (PaymentRequest)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<PaymentRequest> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PaymentRequest>>(){});
    }

    public static PaymentRequestBuilder builder() {
        return new PaymentRequestBuilder();
    }

    public Integer getAmount() {
        return this.amount;
    }

    public Map<String, ?> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="amount")
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, ?> metadata) {
        this.metadata = metadata;
    }

    @Deprecated
    public PaymentRequest(Integer amount, Map<String, ?> metadata, String walletPlatform) {
        this.amount = amount;
        this.metadata = metadata;
        this.walletPlatform = walletPlatform;
    }

    public PaymentRequest() {
    }

    public static class PaymentRequestBuilder {
        private Integer amount;
        private Map<String, ?> metadata;
        private String walletPlatform;

        public PaymentRequestBuilder walletPlatform(String walletPlatform) {
            this.walletPlatform = walletPlatform;
            return this;
        }

        public PaymentRequestBuilder walletPlatformFromEnum(WalletPlatform walletPlatform) {
            this.walletPlatform = walletPlatform.toString();
            return this;
        }

        PaymentRequestBuilder() {
        }

        @JsonProperty(value="amount")
        public PaymentRequestBuilder amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        @JsonProperty(value="metadata")
        public PaymentRequestBuilder metadata(Map<String, ?> metadata) {
            this.metadata = metadata;
            return this;
        }

        public PaymentRequest build() {
            return new PaymentRequest(this.amount, this.metadata, this.walletPlatform);
        }

        public String toString() {
            return "PaymentRequest.PaymentRequestBuilder(amount=" + this.amount + ", metadata=" + this.metadata + ", walletPlatform=" + this.walletPlatform + ")";
        }
    }

    public static enum WalletPlatform {
        Epic("Epic"),
        GooglePlay("GooglePlay"),
        IOS("IOS"),
        Nintendo("Nintendo"),
        Oculus("Oculus"),
        Other("Other"),
        Playstation("Playstation"),
        Steam("Steam"),
        Xbox("Xbox");

        private String value;

        private WalletPlatform(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

