/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentOrderNotifySimulation
extends Model {
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer amount;
    @JsonProperty(value="currencyCode")
    private String currencyCode;
    @JsonProperty(value="notifyType")
    private String notifyType;
    @JsonProperty(value="paymentProvider")
    private String paymentProvider;
    @JsonProperty(value="salesTax")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer salesTax;
    @JsonProperty(value="vat")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer vat;

    @JsonIgnore
    public String getNotifyType() {
        return this.notifyType;
    }

    @JsonIgnore
    public NotifyType getNotifyTypeAsEnum() {
        return NotifyType.valueOf(this.notifyType);
    }

    @JsonIgnore
    public void setNotifyType(String notifyType) {
        this.notifyType = notifyType;
    }

    @JsonIgnore
    public void setNotifyTypeFromEnum(NotifyType notifyType) {
        this.notifyType = notifyType.toString();
    }

    @JsonIgnore
    public String getPaymentProvider() {
        return this.paymentProvider;
    }

    @JsonIgnore
    public PaymentProvider getPaymentProviderAsEnum() {
        return PaymentProvider.valueOf(this.paymentProvider);
    }

    @JsonIgnore
    public void setPaymentProvider(String paymentProvider) {
        this.paymentProvider = paymentProvider;
    }

    @JsonIgnore
    public void setPaymentProviderFromEnum(PaymentProvider paymentProvider) {
        this.paymentProvider = paymentProvider.toString();
    }

    @JsonIgnore
    public PaymentOrderNotifySimulation createFromJson(String json) throws JsonProcessingException {
        return (PaymentOrderNotifySimulation)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<PaymentOrderNotifySimulation> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PaymentOrderNotifySimulation>>(){});
    }

    public static PaymentOrderNotifySimulationBuilder builder() {
        return new PaymentOrderNotifySimulationBuilder();
    }

    public Integer getAmount() {
        return this.amount;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public Integer getSalesTax() {
        return this.salesTax;
    }

    public Integer getVat() {
        return this.vat;
    }

    @JsonProperty(value="amount")
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @JsonProperty(value="currencyCode")
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @JsonProperty(value="salesTax")
    public void setSalesTax(Integer salesTax) {
        this.salesTax = salesTax;
    }

    @JsonProperty(value="vat")
    public void setVat(Integer vat) {
        this.vat = vat;
    }

    @Deprecated
    public PaymentOrderNotifySimulation(Integer amount, String currencyCode, String notifyType, String paymentProvider, Integer salesTax, Integer vat) {
        this.amount = amount;
        this.currencyCode = currencyCode;
        this.notifyType = notifyType;
        this.paymentProvider = paymentProvider;
        this.salesTax = salesTax;
        this.vat = vat;
    }

    public PaymentOrderNotifySimulation() {
    }

    public static class PaymentOrderNotifySimulationBuilder {
        private Integer amount;
        private String currencyCode;
        private Integer salesTax;
        private Integer vat;
        private String notifyType;
        private String paymentProvider;

        public PaymentOrderNotifySimulationBuilder notifyType(String notifyType) {
            this.notifyType = notifyType;
            return this;
        }

        public PaymentOrderNotifySimulationBuilder notifyTypeFromEnum(NotifyType notifyType) {
            this.notifyType = notifyType.toString();
            return this;
        }

        public PaymentOrderNotifySimulationBuilder paymentProvider(String paymentProvider) {
            this.paymentProvider = paymentProvider;
            return this;
        }

        public PaymentOrderNotifySimulationBuilder paymentProviderFromEnum(PaymentProvider paymentProvider) {
            this.paymentProvider = paymentProvider.toString();
            return this;
        }

        PaymentOrderNotifySimulationBuilder() {
        }

        @JsonProperty(value="amount")
        public PaymentOrderNotifySimulationBuilder amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        @JsonProperty(value="currencyCode")
        public PaymentOrderNotifySimulationBuilder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @JsonProperty(value="salesTax")
        public PaymentOrderNotifySimulationBuilder salesTax(Integer salesTax) {
            this.salesTax = salesTax;
            return this;
        }

        @JsonProperty(value="vat")
        public PaymentOrderNotifySimulationBuilder vat(Integer vat) {
            this.vat = vat;
            return this;
        }

        public PaymentOrderNotifySimulation build() {
            return new PaymentOrderNotifySimulation(this.amount, this.currencyCode, this.notifyType, this.paymentProvider, this.salesTax, this.vat);
        }

        public String toString() {
            return "PaymentOrderNotifySimulation.PaymentOrderNotifySimulationBuilder(amount=" + this.amount + ", currencyCode=" + this.currencyCode + ", notifyType=" + this.notifyType + ", paymentProvider=" + this.paymentProvider + ", salesTax=" + this.salesTax + ", vat=" + this.vat + ")";
        }
    }

    public static enum PaymentProvider {
        ADYEN("ADYEN"),
        ALIPAY("ALIPAY"),
        CHECKOUT("CHECKOUT"),
        PAYPAL("PAYPAL"),
        STRIPE("STRIPE"),
        WALLET("WALLET"),
        WXPAY("WXPAY"),
        XSOLLA("XSOLLA");

        private String value;

        private PaymentProvider(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum NotifyType {
        CHARGE("CHARGE"),
        REFUND("REFUND");

        private String value;

        private NotifyType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

