/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentAccount
extends Model {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private String type;

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public Type getTypeAsEnum() {
        return Type.valueOf(this.type);
    }

    @JsonIgnore
    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public void setTypeFromEnum(Type type) {
        this.type = type.toString();
    }

    @JsonIgnore
    public PaymentAccount createFromJson(String json) throws JsonProcessingException {
        return (PaymentAccount)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<PaymentAccount> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PaymentAccount>>(){});
    }

    public static PaymentAccountBuilder builder() {
        return new PaymentAccountBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public PaymentAccount(String id, String name, String type) {
        this.id = id;
        this.name = name;
        this.type = type;
    }

    public PaymentAccount() {
    }

    public static class PaymentAccountBuilder {
        private String id;
        private String name;
        private String type;

        public PaymentAccountBuilder type(String type) {
            this.type = type;
            return this;
        }

        public PaymentAccountBuilder typeFromEnum(Type type) {
            this.type = type.toString();
            return this;
        }

        PaymentAccountBuilder() {
        }

        @JsonProperty(value="id")
        public PaymentAccountBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="name")
        public PaymentAccountBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PaymentAccount build() {
            return new PaymentAccount(this.id, this.name, this.type);
        }

        public String toString() {
            return "PaymentAccount.PaymentAccountBuilder(id=" + this.id + ", name=" + this.name + ", type=" + this.type + ")";
        }
    }

    public static enum Type {
        Card("card"),
        Paypal("paypal");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

