/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MockIAPReceipt
extends Model {
    @JsonProperty(value="itemIdentityType")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String itemIdentityType;
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String language;
    @JsonProperty(value="productId")
    private String productId;
    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String region;
    @JsonProperty(value="transactionId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String transactionId;
    @JsonProperty(value="type")
    private String type;

    @JsonIgnore
    public String getItemIdentityType() {
        return this.itemIdentityType;
    }

    @JsonIgnore
    public ItemIdentityType getItemIdentityTypeAsEnum() {
        return ItemIdentityType.valueOf(this.itemIdentityType);
    }

    @JsonIgnore
    public void setItemIdentityType(String itemIdentityType) {
        this.itemIdentityType = itemIdentityType;
    }

    @JsonIgnore
    public void setItemIdentityTypeFromEnum(ItemIdentityType itemIdentityType) {
        this.itemIdentityType = itemIdentityType.toString();
    }

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public Type getTypeAsEnum() {
        return Type.valueOf(this.type);
    }

    @JsonIgnore
    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public void setTypeFromEnum(Type type) {
        this.type = type.toString();
    }

    @JsonIgnore
    public MockIAPReceipt createFromJson(String json) throws JsonProcessingException {
        return (MockIAPReceipt)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<MockIAPReceipt> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<MockIAPReceipt>>(){});
    }

    public static MockIAPReceiptBuilder builder() {
        return new MockIAPReceiptBuilder();
    }

    public String getLanguage() {
        return this.language;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getRegion() {
        return this.region;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    @JsonProperty(value="productId")
    public void setProductId(String productId) {
        this.productId = productId;
    }

    @JsonProperty(value="region")
    public void setRegion(String region) {
        this.region = region;
    }

    @JsonProperty(value="transactionId")
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Deprecated
    public MockIAPReceipt(String itemIdentityType, String language, String productId, String region, String transactionId, String type) {
        this.itemIdentityType = itemIdentityType;
        this.language = language;
        this.productId = productId;
        this.region = region;
        this.transactionId = transactionId;
        this.type = type;
    }

    public MockIAPReceipt() {
    }

    public static class MockIAPReceiptBuilder {
        private String language;
        private String productId;
        private String region;
        private String transactionId;
        private String itemIdentityType;
        private String type;

        public MockIAPReceiptBuilder itemIdentityType(String itemIdentityType) {
            this.itemIdentityType = itemIdentityType;
            return this;
        }

        public MockIAPReceiptBuilder itemIdentityTypeFromEnum(ItemIdentityType itemIdentityType) {
            this.itemIdentityType = itemIdentityType.toString();
            return this;
        }

        public MockIAPReceiptBuilder type(String type) {
            this.type = type;
            return this;
        }

        public MockIAPReceiptBuilder typeFromEnum(Type type) {
            this.type = type.toString();
            return this;
        }

        MockIAPReceiptBuilder() {
        }

        @JsonProperty(value="language")
        public MockIAPReceiptBuilder language(String language) {
            this.language = language;
            return this;
        }

        @JsonProperty(value="productId")
        public MockIAPReceiptBuilder productId(String productId) {
            this.productId = productId;
            return this;
        }

        @JsonProperty(value="region")
        public MockIAPReceiptBuilder region(String region) {
            this.region = region;
            return this;
        }

        @JsonProperty(value="transactionId")
        public MockIAPReceiptBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public MockIAPReceipt build() {
            return new MockIAPReceipt(this.itemIdentityType, this.language, this.productId, this.region, this.transactionId, this.type);
        }

        public String toString() {
            return "MockIAPReceipt.MockIAPReceiptBuilder(itemIdentityType=" + this.itemIdentityType + ", language=" + this.language + ", productId=" + this.productId + ", region=" + this.region + ", transactionId=" + this.transactionId + ", type=" + this.type + ")";
        }
    }

    public static enum Type {
        APPLE("APPLE"),
        EPICGAMES("EPICGAMES"),
        GOOGLE("GOOGLE"),
        OCULUS("OCULUS"),
        PLAYSTATION("PLAYSTATION"),
        STADIA("STADIA"),
        STEAM("STEAM"),
        TWITCH("TWITCH"),
        XBOX("XBOX");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ItemIdentityType {
        ITEMID("ITEM_ID"),
        ITEMSKU("ITEM_SKU");

        private String value;

        private ItemIdentityType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

