/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.api.platform.models.BoxItem;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LootBoxReward
extends Model {
    @JsonProperty(value="lootBoxItems")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<BoxItem> lootBoxItems;
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String name;
    @JsonProperty(value="odds")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Float odds;
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String type;
    @JsonProperty(value="weight")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer weight;

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public Type getTypeAsEnum() {
        return Type.valueOf(this.type);
    }

    @JsonIgnore
    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public void setTypeFromEnum(Type type) {
        this.type = type.toString();
    }

    @JsonIgnore
    public LootBoxReward createFromJson(String json) throws JsonProcessingException {
        return (LootBoxReward)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<LootBoxReward> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<LootBoxReward>>(){});
    }

    public static LootBoxRewardBuilder builder() {
        return new LootBoxRewardBuilder();
    }

    public List<BoxItem> getLootBoxItems() {
        return this.lootBoxItems;
    }

    public String getName() {
        return this.name;
    }

    public Float getOdds() {
        return this.odds;
    }

    public Integer getWeight() {
        return this.weight;
    }

    @JsonProperty(value="lootBoxItems")
    public void setLootBoxItems(List<BoxItem> lootBoxItems) {
        this.lootBoxItems = lootBoxItems;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="odds")
    public void setOdds(Float odds) {
        this.odds = odds;
    }

    @JsonProperty(value="weight")
    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    @Deprecated
    public LootBoxReward(List<BoxItem> lootBoxItems, String name, Float odds, String type, Integer weight) {
        this.lootBoxItems = lootBoxItems;
        this.name = name;
        this.odds = odds;
        this.type = type;
        this.weight = weight;
    }

    public LootBoxReward() {
    }

    public static class LootBoxRewardBuilder {
        private List<BoxItem> lootBoxItems;
        private String name;
        private Float odds;
        private Integer weight;
        private String type;

        public LootBoxRewardBuilder type(String type) {
            this.type = type;
            return this;
        }

        public LootBoxRewardBuilder typeFromEnum(Type type) {
            this.type = type.toString();
            return this;
        }

        LootBoxRewardBuilder() {
        }

        @JsonProperty(value="lootBoxItems")
        public LootBoxRewardBuilder lootBoxItems(List<BoxItem> lootBoxItems) {
            this.lootBoxItems = lootBoxItems;
            return this;
        }

        @JsonProperty(value="name")
        public LootBoxRewardBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="odds")
        public LootBoxRewardBuilder odds(Float odds) {
            this.odds = odds;
            return this;
        }

        @JsonProperty(value="weight")
        public LootBoxRewardBuilder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public LootBoxReward build() {
            return new LootBoxReward(this.lootBoxItems, this.name, this.odds, this.type, this.weight);
        }

        public String toString() {
            return "LootBoxReward.LootBoxRewardBuilder(lootBoxItems=" + this.lootBoxItems + ", name=" + this.name + ", odds=" + this.odds + ", type=" + this.type + ", weight=" + this.weight + ")";
        }
    }

    public static enum Type {
        PROBABILITYGROUP("PROBABILITY_GROUP"),
        REWARD("REWARD"),
        REWARDGROUP("REWARD_GROUP");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

