/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ItemNaming
extends Model {
    @JsonProperty(value="categoryPath")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String categoryPath;
    @JsonProperty(value="itemId")
    private String itemId;
    @JsonProperty(value="itemType")
    private String itemType;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="namespace")
    private String namespace;
    @JsonProperty(value="seasonType")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String seasonType;
    @JsonProperty(value="sku")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String sku;
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String status;

    @JsonIgnore
    public String getItemType() {
        return this.itemType;
    }

    @JsonIgnore
    public ItemType getItemTypeAsEnum() {
        return ItemType.valueOf(this.itemType);
    }

    @JsonIgnore
    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    @JsonIgnore
    public void setItemTypeFromEnum(ItemType itemType) {
        this.itemType = itemType.toString();
    }

    @JsonIgnore
    public String getSeasonType() {
        return this.seasonType;
    }

    @JsonIgnore
    public SeasonType getSeasonTypeAsEnum() {
        return SeasonType.valueOf(this.seasonType);
    }

    @JsonIgnore
    public void setSeasonType(String seasonType) {
        this.seasonType = seasonType;
    }

    @JsonIgnore
    public void setSeasonTypeFromEnum(SeasonType seasonType) {
        this.seasonType = seasonType.toString();
    }

    @JsonIgnore
    public String getStatus() {
        return this.status;
    }

    @JsonIgnore
    public Status getStatusAsEnum() {
        return Status.valueOf(this.status);
    }

    @JsonIgnore
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonIgnore
    public void setStatusFromEnum(Status status) {
        this.status = status.toString();
    }

    @JsonIgnore
    public ItemNaming createFromJson(String json) throws JsonProcessingException {
        return (ItemNaming)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<ItemNaming> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<ItemNaming>>(){});
    }

    public static ItemNamingBuilder builder() {
        return new ItemNamingBuilder();
    }

    public String getCategoryPath() {
        return this.categoryPath;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSku() {
        return this.sku;
    }

    @JsonProperty(value="categoryPath")
    public void setCategoryPath(String categoryPath) {
        this.categoryPath = categoryPath;
    }

    @JsonProperty(value="itemId")
    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="sku")
    public void setSku(String sku) {
        this.sku = sku;
    }

    @Deprecated
    public ItemNaming(String categoryPath, String itemId, String itemType, String name, String namespace, String seasonType, String sku, String status) {
        this.categoryPath = categoryPath;
        this.itemId = itemId;
        this.itemType = itemType;
        this.name = name;
        this.namespace = namespace;
        this.seasonType = seasonType;
        this.sku = sku;
        this.status = status;
    }

    public ItemNaming() {
    }

    public static class ItemNamingBuilder {
        private String categoryPath;
        private String itemId;
        private String name;
        private String namespace;
        private String sku;
        private String itemType;
        private String seasonType;
        private String status;

        public ItemNamingBuilder itemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        public ItemNamingBuilder itemTypeFromEnum(ItemType itemType) {
            this.itemType = itemType.toString();
            return this;
        }

        public ItemNamingBuilder seasonType(String seasonType) {
            this.seasonType = seasonType;
            return this;
        }

        public ItemNamingBuilder seasonTypeFromEnum(SeasonType seasonType) {
            this.seasonType = seasonType.toString();
            return this;
        }

        public ItemNamingBuilder status(String status) {
            this.status = status;
            return this;
        }

        public ItemNamingBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        ItemNamingBuilder() {
        }

        @JsonProperty(value="categoryPath")
        public ItemNamingBuilder categoryPath(String categoryPath) {
            this.categoryPath = categoryPath;
            return this;
        }

        @JsonProperty(value="itemId")
        public ItemNamingBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        @JsonProperty(value="name")
        public ItemNamingBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="namespace")
        public ItemNamingBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @JsonProperty(value="sku")
        public ItemNamingBuilder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public ItemNaming build() {
            return new ItemNaming(this.categoryPath, this.itemId, this.itemType, this.name, this.namespace, this.seasonType, this.sku, this.status);
        }

        public String toString() {
            return "ItemNaming.ItemNamingBuilder(categoryPath=" + this.categoryPath + ", itemId=" + this.itemId + ", itemType=" + this.itemType + ", name=" + this.name + ", namespace=" + this.namespace + ", seasonType=" + this.seasonType + ", sku=" + this.sku + ", status=" + this.status + ")";
        }
    }

    public static enum Status {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum SeasonType {
        PASS("PASS"),
        TIER("TIER");

        private String value;

        private SeasonType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ItemType {
        APP("APP"),
        BUNDLE("BUNDLE"),
        CODE("CODE"),
        COINS("COINS"),
        EXTENSION("EXTENSION"),
        INGAMEITEM("INGAMEITEM"),
        LOOTBOX("LOOTBOX"),
        MEDIA("MEDIA"),
        OPTIONBOX("OPTIONBOX"),
        SEASON("SEASON"),
        SUBSCRIPTION("SUBSCRIPTION");

        private String value;

        private ItemType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

