/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IAPItemFlatEntry
extends Model {
    @JsonProperty(value="itemIdentity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String itemIdentity;
    @JsonProperty(value="itemIdentityType")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String itemIdentityType;
    @JsonProperty(value="platform")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String platform;
    @JsonProperty(value="platformProductId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String platformProductId;

    @JsonIgnore
    public String getItemIdentityType() {
        return this.itemIdentityType;
    }

    @JsonIgnore
    public ItemIdentityType getItemIdentityTypeAsEnum() {
        return ItemIdentityType.valueOf(this.itemIdentityType);
    }

    @JsonIgnore
    public void setItemIdentityType(String itemIdentityType) {
        this.itemIdentityType = itemIdentityType;
    }

    @JsonIgnore
    public void setItemIdentityTypeFromEnum(ItemIdentityType itemIdentityType) {
        this.itemIdentityType = itemIdentityType.toString();
    }

    @JsonIgnore
    public String getPlatform() {
        return this.platform;
    }

    @JsonIgnore
    public Platform getPlatformAsEnum() {
        return Platform.valueOf(this.platform);
    }

    @JsonIgnore
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @JsonIgnore
    public void setPlatformFromEnum(Platform platform) {
        this.platform = platform.toString();
    }

    @JsonIgnore
    public IAPItemFlatEntry createFromJson(String json) throws JsonProcessingException {
        return (IAPItemFlatEntry)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<IAPItemFlatEntry> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<IAPItemFlatEntry>>(){});
    }

    public static IAPItemFlatEntryBuilder builder() {
        return new IAPItemFlatEntryBuilder();
    }

    public String getItemIdentity() {
        return this.itemIdentity;
    }

    public String getPlatformProductId() {
        return this.platformProductId;
    }

    @JsonProperty(value="itemIdentity")
    public void setItemIdentity(String itemIdentity) {
        this.itemIdentity = itemIdentity;
    }

    @JsonProperty(value="platformProductId")
    public void setPlatformProductId(String platformProductId) {
        this.platformProductId = platformProductId;
    }

    @Deprecated
    public IAPItemFlatEntry(String itemIdentity, String itemIdentityType, String platform, String platformProductId) {
        this.itemIdentity = itemIdentity;
        this.itemIdentityType = itemIdentityType;
        this.platform = platform;
        this.platformProductId = platformProductId;
    }

    public IAPItemFlatEntry() {
    }

    public static class IAPItemFlatEntryBuilder {
        private String itemIdentity;
        private String platformProductId;
        private String itemIdentityType;
        private String platform;

        public IAPItemFlatEntryBuilder itemIdentityType(String itemIdentityType) {
            this.itemIdentityType = itemIdentityType;
            return this;
        }

        public IAPItemFlatEntryBuilder itemIdentityTypeFromEnum(ItemIdentityType itemIdentityType) {
            this.itemIdentityType = itemIdentityType.toString();
            return this;
        }

        public IAPItemFlatEntryBuilder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public IAPItemFlatEntryBuilder platformFromEnum(Platform platform) {
            this.platform = platform.toString();
            return this;
        }

        IAPItemFlatEntryBuilder() {
        }

        @JsonProperty(value="itemIdentity")
        public IAPItemFlatEntryBuilder itemIdentity(String itemIdentity) {
            this.itemIdentity = itemIdentity;
            return this;
        }

        @JsonProperty(value="platformProductId")
        public IAPItemFlatEntryBuilder platformProductId(String platformProductId) {
            this.platformProductId = platformProductId;
            return this;
        }

        public IAPItemFlatEntry build() {
            return new IAPItemFlatEntry(this.itemIdentity, this.itemIdentityType, this.platform, this.platformProductId);
        }

        public String toString() {
            return "IAPItemFlatEntry.IAPItemFlatEntryBuilder(itemIdentity=" + this.itemIdentity + ", itemIdentityType=" + this.itemIdentityType + ", platform=" + this.platform + ", platformProductId=" + this.platformProductId + ")";
        }
    }

    public static enum Platform {
        APPLE("APPLE"),
        EPICGAMES("EPICGAMES"),
        GOOGLE("GOOGLE"),
        OCULUS("OCULUS"),
        PLAYSTATION("PLAYSTATION"),
        STADIA("STADIA"),
        STEAM("STEAM"),
        TWITCH("TWITCH"),
        XBOX("XBOX");

        private String value;

        private Platform(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ItemIdentityType {
        ITEMID("ITEM_ID"),
        ITEMSKU("ITEM_SKU");

        private String value;

        private ItemIdentityType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

