/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IAPItemEntry
extends Model {
    @JsonProperty(value="itemIdentity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String itemIdentity;
    @JsonProperty(value="itemIdentityType")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String itemIdentityType;
    @JsonProperty(value="platformProductIdMap")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, String> platformProductIdMap;

    @JsonIgnore
    public String getItemIdentityType() {
        return this.itemIdentityType;
    }

    @JsonIgnore
    public ItemIdentityType getItemIdentityTypeAsEnum() {
        return ItemIdentityType.valueOf(this.itemIdentityType);
    }

    @JsonIgnore
    public void setItemIdentityType(String itemIdentityType) {
        this.itemIdentityType = itemIdentityType;
    }

    @JsonIgnore
    public void setItemIdentityTypeFromEnum(ItemIdentityType itemIdentityType) {
        this.itemIdentityType = itemIdentityType.toString();
    }

    @JsonIgnore
    public IAPItemEntry createFromJson(String json) throws JsonProcessingException {
        return (IAPItemEntry)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<IAPItemEntry> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<IAPItemEntry>>(){});
    }

    public static IAPItemEntryBuilder builder() {
        return new IAPItemEntryBuilder();
    }

    public String getItemIdentity() {
        return this.itemIdentity;
    }

    public Map<String, String> getPlatformProductIdMap() {
        return this.platformProductIdMap;
    }

    @JsonProperty(value="itemIdentity")
    public void setItemIdentity(String itemIdentity) {
        this.itemIdentity = itemIdentity;
    }

    @JsonProperty(value="platformProductIdMap")
    public void setPlatformProductIdMap(Map<String, String> platformProductIdMap) {
        this.platformProductIdMap = platformProductIdMap;
    }

    @Deprecated
    public IAPItemEntry(String itemIdentity, String itemIdentityType, Map<String, String> platformProductIdMap) {
        this.itemIdentity = itemIdentity;
        this.itemIdentityType = itemIdentityType;
        this.platformProductIdMap = platformProductIdMap;
    }

    public IAPItemEntry() {
    }

    public static class IAPItemEntryBuilder {
        private String itemIdentity;
        private Map<String, String> platformProductIdMap;
        private String itemIdentityType;

        public IAPItemEntryBuilder itemIdentityType(String itemIdentityType) {
            this.itemIdentityType = itemIdentityType;
            return this;
        }

        public IAPItemEntryBuilder itemIdentityTypeFromEnum(ItemIdentityType itemIdentityType) {
            this.itemIdentityType = itemIdentityType.toString();
            return this;
        }

        IAPItemEntryBuilder() {
        }

        @JsonProperty(value="itemIdentity")
        public IAPItemEntryBuilder itemIdentity(String itemIdentity) {
            this.itemIdentity = itemIdentity;
            return this;
        }

        @JsonProperty(value="platformProductIdMap")
        public IAPItemEntryBuilder platformProductIdMap(Map<String, String> platformProductIdMap) {
            this.platformProductIdMap = platformProductIdMap;
            return this;
        }

        public IAPItemEntry build() {
            return new IAPItemEntry(this.itemIdentity, this.itemIdentityType, this.platformProductIdMap);
        }

        public String toString() {
            return "IAPItemEntry.IAPItemEntryBuilder(itemIdentity=" + this.itemIdentity + ", itemIdentityType=" + this.itemIdentityType + ", platformProductIdMap=" + this.platformProductIdMap + ")";
        }
    }

    public static enum ItemIdentityType {
        ITEMID("ITEM_ID"),
        ITEMSKU("ITEM_SKU");

        private String value;

        private ItemIdentityType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

