/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.api.platform.models.TLSConfig;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GrpcServerInfo
extends Model {
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String address;
    @JsonProperty(value="connectionTypeEnum")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String connectionTypeEnum;
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String status;
    @JsonProperty(value="tlsConfig")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private TLSConfig tlsConfig;

    @JsonIgnore
    public String getConnectionTypeEnum() {
        return this.connectionTypeEnum;
    }

    @JsonIgnore
    public ConnectionTypeEnum getConnectionTypeEnumAsEnum() {
        return ConnectionTypeEnum.valueOf(this.connectionTypeEnum);
    }

    @JsonIgnore
    public void setConnectionTypeEnum(String connectionTypeEnum) {
        this.connectionTypeEnum = connectionTypeEnum;
    }

    @JsonIgnore
    public void setConnectionTypeEnumFromEnum(ConnectionTypeEnum connectionTypeEnum) {
        this.connectionTypeEnum = connectionTypeEnum.toString();
    }

    @JsonIgnore
    public GrpcServerInfo createFromJson(String json) throws JsonProcessingException {
        return (GrpcServerInfo)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<GrpcServerInfo> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<GrpcServerInfo>>(){});
    }

    public static GrpcServerInfoBuilder builder() {
        return new GrpcServerInfoBuilder();
    }

    public String getAddress() {
        return this.address;
    }

    public String getStatus() {
        return this.status;
    }

    public TLSConfig getTlsConfig() {
        return this.tlsConfig;
    }

    @JsonProperty(value="address")
    public void setAddress(String address) {
        this.address = address;
    }

    @JsonProperty(value="status")
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="tlsConfig")
    public void setTlsConfig(TLSConfig tlsConfig) {
        this.tlsConfig = tlsConfig;
    }

    @Deprecated
    public GrpcServerInfo(String address, String connectionTypeEnum, String status, TLSConfig tlsConfig) {
        this.address = address;
        this.connectionTypeEnum = connectionTypeEnum;
        this.status = status;
        this.tlsConfig = tlsConfig;
    }

    public GrpcServerInfo() {
    }

    public static class GrpcServerInfoBuilder {
        private String address;
        private String status;
        private TLSConfig tlsConfig;
        private String connectionTypeEnum;

        public GrpcServerInfoBuilder connectionTypeEnum(String connectionTypeEnum) {
            this.connectionTypeEnum = connectionTypeEnum;
            return this;
        }

        public GrpcServerInfoBuilder connectionTypeEnumFromEnum(ConnectionTypeEnum connectionTypeEnum) {
            this.connectionTypeEnum = connectionTypeEnum.toString();
            return this;
        }

        GrpcServerInfoBuilder() {
        }

        @JsonProperty(value="address")
        public GrpcServerInfoBuilder address(String address) {
            this.address = address;
            return this;
        }

        @JsonProperty(value="status")
        public GrpcServerInfoBuilder status(String status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="tlsConfig")
        public GrpcServerInfoBuilder tlsConfig(TLSConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        public GrpcServerInfo build() {
            return new GrpcServerInfo(this.address, this.connectionTypeEnum, this.status, this.tlsConfig);
        }

        public String toString() {
            return "GrpcServerInfo.GrpcServerInfoBuilder(address=" + this.address + ", connectionTypeEnum=" + this.connectionTypeEnum + ", status=" + this.status + ", tlsConfig=" + (Object)((Object)this.tlsConfig) + ")";
        }
    }

    public static enum ConnectionTypeEnum {
        INSECURE("INSECURE"),
        TLS("TLS");

        private String value;

        private ConnectionTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

