/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.OrderSummary;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FulfillmentRequest
extends Model {
    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer duration;
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String endDate;
    @JsonProperty(value="itemId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String itemId;
    @JsonProperty(value="itemSku")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String itemSku;
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String language;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, ?> metadata;
    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OrderSummary order;
    @JsonProperty(value="orderNo")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String orderNo;
    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String origin;
    @JsonProperty(value="overrideBundleItemQty")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, Integer> overrideBundleItemQty;
    @JsonProperty(value="quantity")
    private Integer quantity;
    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String region;
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String source;
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String startDate;
    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String storeId;

    @JsonIgnore
    public String getOrigin() {
        return this.origin;
    }

    @JsonIgnore
    public Origin getOriginAsEnum() {
        return Origin.valueOf(this.origin);
    }

    @JsonIgnore
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    @JsonIgnore
    public void setOriginFromEnum(Origin origin) {
        this.origin = origin.toString();
    }

    @JsonIgnore
    public String getSource() {
        return this.source;
    }

    @JsonIgnore
    public Source getSourceAsEnum() {
        return Source.valueOf(this.source);
    }

    @JsonIgnore
    public void setSource(String source) {
        this.source = source;
    }

    @JsonIgnore
    public void setSourceFromEnum(Source source) {
        this.source = source.toString();
    }

    @JsonIgnore
    public FulfillmentRequest createFromJson(String json) throws JsonProcessingException {
        return (FulfillmentRequest)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<FulfillmentRequest> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<FulfillmentRequest>>(){});
    }

    public static FulfillmentRequestBuilder builder() {
        return new FulfillmentRequestBuilder();
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getItemSku() {
        return this.itemSku;
    }

    public String getLanguage() {
        return this.language;
    }

    public Map<String, ?> getMetadata() {
        return this.metadata;
    }

    public OrderSummary getOrder() {
        return this.order;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public Map<String, Integer> getOverrideBundleItemQty() {
        return this.overrideBundleItemQty;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public String getRegion() {
        return this.region;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getStoreId() {
        return this.storeId;
    }

    @JsonProperty(value="duration")
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @JsonProperty(value="endDate")
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    @JsonProperty(value="itemId")
    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    @JsonProperty(value="itemSku")
    public void setItemSku(String itemSku) {
        this.itemSku = itemSku;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, ?> metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="order")
    public void setOrder(OrderSummary order) {
        this.order = order;
    }

    @JsonProperty(value="orderNo")
    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    @JsonProperty(value="overrideBundleItemQty")
    public void setOverrideBundleItemQty(Map<String, Integer> overrideBundleItemQty) {
        this.overrideBundleItemQty = overrideBundleItemQty;
    }

    @JsonProperty(value="quantity")
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @JsonProperty(value="region")
    public void setRegion(String region) {
        this.region = region;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="storeId")
    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    @Deprecated
    public FulfillmentRequest(Integer duration, String endDate, String itemId, String itemSku, String language, Map<String, ?> metadata, OrderSummary order, String orderNo, String origin, Map<String, Integer> overrideBundleItemQty, Integer quantity, String region, String source, String startDate, String storeId) {
        this.duration = duration;
        this.endDate = endDate;
        this.itemId = itemId;
        this.itemSku = itemSku;
        this.language = language;
        this.metadata = metadata;
        this.order = order;
        this.orderNo = orderNo;
        this.origin = origin;
        this.overrideBundleItemQty = overrideBundleItemQty;
        this.quantity = quantity;
        this.region = region;
        this.source = source;
        this.startDate = startDate;
        this.storeId = storeId;
    }

    public FulfillmentRequest() {
    }

    public static class FulfillmentRequestBuilder {
        private Integer duration;
        private String endDate;
        private String itemId;
        private String itemSku;
        private String language;
        private Map<String, ?> metadata;
        private OrderSummary order;
        private String orderNo;
        private Map<String, Integer> overrideBundleItemQty;
        private Integer quantity;
        private String region;
        private String startDate;
        private String storeId;
        private String origin;
        private String source;

        public FulfillmentRequestBuilder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public FulfillmentRequestBuilder originFromEnum(Origin origin) {
            this.origin = origin.toString();
            return this;
        }

        public FulfillmentRequestBuilder source(String source) {
            this.source = source;
            return this;
        }

        public FulfillmentRequestBuilder sourceFromEnum(Source source) {
            this.source = source.toString();
            return this;
        }

        FulfillmentRequestBuilder() {
        }

        @JsonProperty(value="duration")
        public FulfillmentRequestBuilder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        @JsonProperty(value="endDate")
        public FulfillmentRequestBuilder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        @JsonProperty(value="itemId")
        public FulfillmentRequestBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        @JsonProperty(value="itemSku")
        public FulfillmentRequestBuilder itemSku(String itemSku) {
            this.itemSku = itemSku;
            return this;
        }

        @JsonProperty(value="language")
        public FulfillmentRequestBuilder language(String language) {
            this.language = language;
            return this;
        }

        @JsonProperty(value="metadata")
        public FulfillmentRequestBuilder metadata(Map<String, ?> metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="order")
        public FulfillmentRequestBuilder order(OrderSummary order) {
            this.order = order;
            return this;
        }

        @JsonProperty(value="orderNo")
        public FulfillmentRequestBuilder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }

        @JsonProperty(value="overrideBundleItemQty")
        public FulfillmentRequestBuilder overrideBundleItemQty(Map<String, Integer> overrideBundleItemQty) {
            this.overrideBundleItemQty = overrideBundleItemQty;
            return this;
        }

        @JsonProperty(value="quantity")
        public FulfillmentRequestBuilder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        @JsonProperty(value="region")
        public FulfillmentRequestBuilder region(String region) {
            this.region = region;
            return this;
        }

        @JsonProperty(value="startDate")
        public FulfillmentRequestBuilder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        @JsonProperty(value="storeId")
        public FulfillmentRequestBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public FulfillmentRequest build() {
            return new FulfillmentRequest(this.duration, this.endDate, this.itemId, this.itemSku, this.language, this.metadata, this.order, this.orderNo, this.origin, this.overrideBundleItemQty, this.quantity, this.region, this.source, this.startDate, this.storeId);
        }

        public String toString() {
            return "FulfillmentRequest.FulfillmentRequestBuilder(duration=" + this.duration + ", endDate=" + this.endDate + ", itemId=" + this.itemId + ", itemSku=" + this.itemSku + ", language=" + this.language + ", metadata=" + this.metadata + ", order=" + (Object)((Object)this.order) + ", orderNo=" + this.orderNo + ", origin=" + this.origin + ", overrideBundleItemQty=" + this.overrideBundleItemQty + ", quantity=" + this.quantity + ", region=" + this.region + ", source=" + this.source + ", startDate=" + this.startDate + ", storeId=" + this.storeId + ")";
        }
    }

    public static enum Source {
        ACHIEVEMENT("ACHIEVEMENT"),
        CONSUMEENTITLEMENT("CONSUME_ENTITLEMENT"),
        DLC("DLC"),
        EXPIRATION("EXPIRATION"),
        GIFT("GIFT"),
        IAP("IAP"),
        IAPCHARGEBACKREVERSED("IAP_CHARGEBACK_REVERSED"),
        ORDERREVOCATION("ORDER_REVOCATION"),
        OTHER("OTHER"),
        PAYMENT("PAYMENT"),
        PROMOTION("PROMOTION"),
        PURCHASE("PURCHASE"),
        REDEEMCODE("REDEEM_CODE"),
        REFERRALBONUS("REFERRAL_BONUS"),
        REWARD("REWARD"),
        SELLBACK("SELL_BACK");

        private String value;

        private Source(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Origin {
        Epic("Epic"),
        GooglePlay("GooglePlay"),
        IOS("IOS"),
        Nintendo("Nintendo"),
        Oculus("Oculus"),
        Other("Other"),
        Playstation("Playstation"),
        Steam("Steam"),
        System("System"),
        Twitch("Twitch"),
        Xbox("Xbox");

        private String value;

        private Origin(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

