/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DebitRequest
extends Model {
    @JsonProperty(value="amount")
    private Integer amount;
    @JsonProperty(value="balanceSource")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String balanceSource;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, ?> metadata;
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String reason;

    @JsonIgnore
    public String getBalanceSource() {
        return this.balanceSource;
    }

    @JsonIgnore
    public BalanceSource getBalanceSourceAsEnum() {
        return BalanceSource.valueOf(this.balanceSource);
    }

    @JsonIgnore
    public void setBalanceSource(String balanceSource) {
        this.balanceSource = balanceSource;
    }

    @JsonIgnore
    public void setBalanceSourceFromEnum(BalanceSource balanceSource) {
        this.balanceSource = balanceSource.toString();
    }

    @JsonIgnore
    public DebitRequest createFromJson(String json) throws JsonProcessingException {
        return (DebitRequest)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<DebitRequest> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<DebitRequest>>(){});
    }

    public static DebitRequestBuilder builder() {
        return new DebitRequestBuilder();
    }

    public Integer getAmount() {
        return this.amount;
    }

    public Map<String, ?> getMetadata() {
        return this.metadata;
    }

    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="amount")
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, ?> metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Deprecated
    public DebitRequest(Integer amount, String balanceSource, Map<String, ?> metadata, String reason) {
        this.amount = amount;
        this.balanceSource = balanceSource;
        this.metadata = metadata;
        this.reason = reason;
    }

    public DebitRequest() {
    }

    public static class DebitRequestBuilder {
        private Integer amount;
        private Map<String, ?> metadata;
        private String reason;
        private String balanceSource;

        public DebitRequestBuilder balanceSource(String balanceSource) {
            this.balanceSource = balanceSource;
            return this;
        }

        public DebitRequestBuilder balanceSourceFromEnum(BalanceSource balanceSource) {
            this.balanceSource = balanceSource.toString();
            return this;
        }

        DebitRequestBuilder() {
        }

        @JsonProperty(value="amount")
        public DebitRequestBuilder amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        @JsonProperty(value="metadata")
        public DebitRequestBuilder metadata(Map<String, ?> metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="reason")
        public DebitRequestBuilder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public DebitRequest build() {
            return new DebitRequest(this.amount, this.balanceSource, this.metadata, this.reason);
        }

        public String toString() {
            return "DebitRequest.DebitRequestBuilder(amount=" + this.amount + ", balanceSource=" + this.balanceSource + ", metadata=" + this.metadata + ", reason=" + this.reason + ")";
        }
    }

    public static enum BalanceSource {
        DLCREVOCATION("DLC_REVOCATION"),
        EXPIRATION("EXPIRATION"),
        IAPREVOCATION("IAP_REVOCATION"),
        ORDERREVOCATION("ORDER_REVOCATION"),
        OTHER("OTHER"),
        PAYMENT("PAYMENT");

        private String value;

        private BalanceSource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

