/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DebitByCurrencyCodeRequest
extends Model {
    @JsonProperty(value="allowOverdraft")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean allowOverdraft;
    @JsonProperty(value="amount")
    private Integer amount;
    @JsonProperty(value="balanceOrigin")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String balanceOrigin;
    @JsonProperty(value="balanceSource")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String balanceSource;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, ?> metadata;
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String reason;

    @JsonIgnore
    public String getBalanceOrigin() {
        return this.balanceOrigin;
    }

    @JsonIgnore
    public BalanceOrigin getBalanceOriginAsEnum() {
        return BalanceOrigin.valueOf(this.balanceOrigin);
    }

    @JsonIgnore
    public void setBalanceOrigin(String balanceOrigin) {
        this.balanceOrigin = balanceOrigin;
    }

    @JsonIgnore
    public void setBalanceOriginFromEnum(BalanceOrigin balanceOrigin) {
        this.balanceOrigin = balanceOrigin.toString();
    }

    @JsonIgnore
    public String getBalanceSource() {
        return this.balanceSource;
    }

    @JsonIgnore
    public BalanceSource getBalanceSourceAsEnum() {
        return BalanceSource.valueOf(this.balanceSource);
    }

    @JsonIgnore
    public void setBalanceSource(String balanceSource) {
        this.balanceSource = balanceSource;
    }

    @JsonIgnore
    public void setBalanceSourceFromEnum(BalanceSource balanceSource) {
        this.balanceSource = balanceSource.toString();
    }

    @JsonIgnore
    public DebitByCurrencyCodeRequest createFromJson(String json) throws JsonProcessingException {
        return (DebitByCurrencyCodeRequest)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<DebitByCurrencyCodeRequest> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<DebitByCurrencyCodeRequest>>(){});
    }

    public static DebitByCurrencyCodeRequestBuilder builder() {
        return new DebitByCurrencyCodeRequestBuilder();
    }

    public Boolean getAllowOverdraft() {
        return this.allowOverdraft;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public Map<String, ?> getMetadata() {
        return this.metadata;
    }

    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="allowOverdraft")
    public void setAllowOverdraft(Boolean allowOverdraft) {
        this.allowOverdraft = allowOverdraft;
    }

    @JsonProperty(value="amount")
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, ?> metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Deprecated
    public DebitByCurrencyCodeRequest(Boolean allowOverdraft, Integer amount, String balanceOrigin, String balanceSource, Map<String, ?> metadata, String reason) {
        this.allowOverdraft = allowOverdraft;
        this.amount = amount;
        this.balanceOrigin = balanceOrigin;
        this.balanceSource = balanceSource;
        this.metadata = metadata;
        this.reason = reason;
    }

    public DebitByCurrencyCodeRequest() {
    }

    public static class DebitByCurrencyCodeRequestBuilder {
        private Boolean allowOverdraft;
        private Integer amount;
        private Map<String, ?> metadata;
        private String reason;
        private String balanceOrigin;
        private String balanceSource;

        public DebitByCurrencyCodeRequestBuilder balanceOrigin(String balanceOrigin) {
            this.balanceOrigin = balanceOrigin;
            return this;
        }

        public DebitByCurrencyCodeRequestBuilder balanceOriginFromEnum(BalanceOrigin balanceOrigin) {
            this.balanceOrigin = balanceOrigin.toString();
            return this;
        }

        public DebitByCurrencyCodeRequestBuilder balanceSource(String balanceSource) {
            this.balanceSource = balanceSource;
            return this;
        }

        public DebitByCurrencyCodeRequestBuilder balanceSourceFromEnum(BalanceSource balanceSource) {
            this.balanceSource = balanceSource.toString();
            return this;
        }

        DebitByCurrencyCodeRequestBuilder() {
        }

        @JsonProperty(value="allowOverdraft")
        public DebitByCurrencyCodeRequestBuilder allowOverdraft(Boolean allowOverdraft) {
            this.allowOverdraft = allowOverdraft;
            return this;
        }

        @JsonProperty(value="amount")
        public DebitByCurrencyCodeRequestBuilder amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        @JsonProperty(value="metadata")
        public DebitByCurrencyCodeRequestBuilder metadata(Map<String, ?> metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="reason")
        public DebitByCurrencyCodeRequestBuilder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public DebitByCurrencyCodeRequest build() {
            return new DebitByCurrencyCodeRequest(this.allowOverdraft, this.amount, this.balanceOrigin, this.balanceSource, this.metadata, this.reason);
        }

        public String toString() {
            return "DebitByCurrencyCodeRequest.DebitByCurrencyCodeRequestBuilder(allowOverdraft=" + this.allowOverdraft + ", amount=" + this.amount + ", balanceOrigin=" + this.balanceOrigin + ", balanceSource=" + this.balanceSource + ", metadata=" + this.metadata + ", reason=" + this.reason + ")";
        }
    }

    public static enum BalanceSource {
        DLCREVOCATION("DLC_REVOCATION"),
        EXPIRATION("EXPIRATION"),
        IAPREVOCATION("IAP_REVOCATION"),
        ORDERREVOCATION("ORDER_REVOCATION"),
        OTHER("OTHER"),
        PAYMENT("PAYMENT");

        private String value;

        private BalanceSource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum BalanceOrigin {
        Epic("Epic"),
        GooglePlay("GooglePlay"),
        IOS("IOS"),
        Nintendo("Nintendo"),
        Oculus("Oculus"),
        Other("Other"),
        Playstation("Playstation"),
        Steam("Steam"),
        System("System"),
        Twitch("Twitch"),
        Xbox("Xbox");

        private String value;

        private BalanceOrigin(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

