/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.PlatformReward;
import net.accelbyte.sdk.api.platform.models.RevocationResult;
import net.accelbyte.sdk.api.platform.models.RevokeResult;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DLCRecord
extends Model {
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String id;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, ?> metadata;
    @JsonProperty(value="obtainedAt")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String obtainedAt;
    @JsonProperty(value="revocationResult")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private RevocationResult revocationResult;
    @JsonProperty(value="revokeResults")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<RevokeResult> revokeResults;
    @JsonProperty(value="revokedAt")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String revokedAt;
    @JsonProperty(value="rewards")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<PlatformReward> rewards;
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> sources;
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String status;
    @JsonProperty(value="transactionId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String transactionId;
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer version;

    @JsonIgnore
    public String getStatus() {
        return this.status;
    }

    @JsonIgnore
    public Status getStatusAsEnum() {
        return Status.valueOf(this.status);
    }

    @JsonIgnore
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonIgnore
    public void setStatusFromEnum(Status status) {
        this.status = status.toString();
    }

    @JsonIgnore
    public DLCRecord createFromJson(String json) throws JsonProcessingException {
        return (DLCRecord)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<DLCRecord> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<DLCRecord>>(){});
    }

    public static DLCRecordBuilder builder() {
        return new DLCRecordBuilder();
    }

    public String getId() {
        return this.id;
    }

    public Map<String, ?> getMetadata() {
        return this.metadata;
    }

    public String getObtainedAt() {
        return this.obtainedAt;
    }

    public RevocationResult getRevocationResult() {
        return this.revocationResult;
    }

    public List<RevokeResult> getRevokeResults() {
        return this.revokeResults;
    }

    public String getRevokedAt() {
        return this.revokedAt;
    }

    public List<PlatformReward> getRewards() {
        return this.rewards;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, ?> metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="obtainedAt")
    public void setObtainedAt(String obtainedAt) {
        this.obtainedAt = obtainedAt;
    }

    @JsonProperty(value="revocationResult")
    public void setRevocationResult(RevocationResult revocationResult) {
        this.revocationResult = revocationResult;
    }

    @JsonProperty(value="revokeResults")
    public void setRevokeResults(List<RevokeResult> revokeResults) {
        this.revokeResults = revokeResults;
    }

    @JsonProperty(value="revokedAt")
    public void setRevokedAt(String revokedAt) {
        this.revokedAt = revokedAt;
    }

    @JsonProperty(value="rewards")
    public void setRewards(List<PlatformReward> rewards) {
        this.rewards = rewards;
    }

    @JsonProperty(value="sources")
    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    @JsonProperty(value="transactionId")
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Deprecated
    public DLCRecord(String id, Map<String, ?> metadata, String obtainedAt, RevocationResult revocationResult, List<RevokeResult> revokeResults, String revokedAt, List<PlatformReward> rewards, List<String> sources, String status, String transactionId, Integer version) {
        this.id = id;
        this.metadata = metadata;
        this.obtainedAt = obtainedAt;
        this.revocationResult = revocationResult;
        this.revokeResults = revokeResults;
        this.revokedAt = revokedAt;
        this.rewards = rewards;
        this.sources = sources;
        this.status = status;
        this.transactionId = transactionId;
        this.version = version;
    }

    public DLCRecord() {
    }

    public static class DLCRecordBuilder {
        private String id;
        private Map<String, ?> metadata;
        private String obtainedAt;
        private RevocationResult revocationResult;
        private List<RevokeResult> revokeResults;
        private String revokedAt;
        private List<PlatformReward> rewards;
        private List<String> sources;
        private String transactionId;
        private Integer version;
        private String status;

        public DLCRecordBuilder status(String status) {
            this.status = status;
            return this;
        }

        public DLCRecordBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        DLCRecordBuilder() {
        }

        @JsonProperty(value="id")
        public DLCRecordBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="metadata")
        public DLCRecordBuilder metadata(Map<String, ?> metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="obtainedAt")
        public DLCRecordBuilder obtainedAt(String obtainedAt) {
            this.obtainedAt = obtainedAt;
            return this;
        }

        @JsonProperty(value="revocationResult")
        public DLCRecordBuilder revocationResult(RevocationResult revocationResult) {
            this.revocationResult = revocationResult;
            return this;
        }

        @JsonProperty(value="revokeResults")
        public DLCRecordBuilder revokeResults(List<RevokeResult> revokeResults) {
            this.revokeResults = revokeResults;
            return this;
        }

        @JsonProperty(value="revokedAt")
        public DLCRecordBuilder revokedAt(String revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        @JsonProperty(value="rewards")
        public DLCRecordBuilder rewards(List<PlatformReward> rewards) {
            this.rewards = rewards;
            return this;
        }

        @JsonProperty(value="sources")
        public DLCRecordBuilder sources(List<String> sources) {
            this.sources = sources;
            return this;
        }

        @JsonProperty(value="transactionId")
        public DLCRecordBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @JsonProperty(value="version")
        public DLCRecordBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public DLCRecord build() {
            return new DLCRecord(this.id, this.metadata, this.obtainedAt, this.revocationResult, this.revokeResults, this.revokedAt, this.rewards, this.sources, this.status, this.transactionId, this.version);
        }

        public String toString() {
            return "DLCRecord.DLCRecordBuilder(id=" + this.id + ", metadata=" + this.metadata + ", obtainedAt=" + this.obtainedAt + ", revocationResult=" + (Object)((Object)this.revocationResult) + ", revokeResults=" + this.revokeResults + ", revokedAt=" + this.revokedAt + ", rewards=" + this.rewards + ", sources=" + this.sources + ", status=" + this.status + ", transactionId=" + this.transactionId + ", version=" + this.version + ")";
        }
    }

    public static enum Status {
        FULFILLED("FULFILLED"),
        REVOKED("REVOKED"),
        REVOKEFAILED("REVOKE_FAILED");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

