/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CurrencySummary
extends Model {
    @JsonProperty(value="currencyCode")
    private String currencyCode;
    @JsonProperty(value="currencySymbol")
    private String currencySymbol;
    @JsonProperty(value="currencyType")
    private String currencyType;
    @JsonProperty(value="decimals")
    private Integer decimals;
    @JsonProperty(value="namespace")
    private String namespace;

    @JsonIgnore
    public String getCurrencyType() {
        return this.currencyType;
    }

    @JsonIgnore
    public CurrencyType getCurrencyTypeAsEnum() {
        return CurrencyType.valueOf(this.currencyType);
    }

    @JsonIgnore
    public void setCurrencyType(String currencyType) {
        this.currencyType = currencyType;
    }

    @JsonIgnore
    public void setCurrencyTypeFromEnum(CurrencyType currencyType) {
        this.currencyType = currencyType.toString();
    }

    @JsonIgnore
    public CurrencySummary createFromJson(String json) throws JsonProcessingException {
        return (CurrencySummary)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<CurrencySummary> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<CurrencySummary>>(){});
    }

    public static CurrencySummaryBuilder builder() {
        return new CurrencySummaryBuilder();
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public Integer getDecimals() {
        return this.decimals;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="currencyCode")
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @JsonProperty(value="currencySymbol")
    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    @JsonProperty(value="decimals")
    public void setDecimals(Integer decimals) {
        this.decimals = decimals;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Deprecated
    public CurrencySummary(String currencyCode, String currencySymbol, String currencyType, Integer decimals, String namespace) {
        this.currencyCode = currencyCode;
        this.currencySymbol = currencySymbol;
        this.currencyType = currencyType;
        this.decimals = decimals;
        this.namespace = namespace;
    }

    public CurrencySummary() {
    }

    public static class CurrencySummaryBuilder {
        private String currencyCode;
        private String currencySymbol;
        private Integer decimals;
        private String namespace;
        private String currencyType;

        public CurrencySummaryBuilder currencyType(String currencyType) {
            this.currencyType = currencyType;
            return this;
        }

        public CurrencySummaryBuilder currencyTypeFromEnum(CurrencyType currencyType) {
            this.currencyType = currencyType.toString();
            return this;
        }

        CurrencySummaryBuilder() {
        }

        @JsonProperty(value="currencyCode")
        public CurrencySummaryBuilder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @JsonProperty(value="currencySymbol")
        public CurrencySummaryBuilder currencySymbol(String currencySymbol) {
            this.currencySymbol = currencySymbol;
            return this;
        }

        @JsonProperty(value="decimals")
        public CurrencySummaryBuilder decimals(Integer decimals) {
            this.decimals = decimals;
            return this;
        }

        @JsonProperty(value="namespace")
        public CurrencySummaryBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public CurrencySummary build() {
            return new CurrencySummary(this.currencyCode, this.currencySymbol, this.currencyType, this.decimals, this.namespace);
        }

        public String toString() {
            return "CurrencySummary.CurrencySummaryBuilder(currencyCode=" + this.currencyCode + ", currencySymbol=" + this.currencySymbol + ", currencyType=" + this.currencyType + ", decimals=" + this.decimals + ", namespace=" + this.namespace + ")";
        }
    }

    public static enum CurrencyType {
        REAL("REAL"),
        VIRTUAL("VIRTUAL");

        private String value;

        private CurrencyType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

