/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CurrencyCreate
extends Model {
    @JsonProperty(value="currencyCode")
    private String currencyCode;
    @JsonProperty(value="currencySymbol")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String currencySymbol;
    @JsonProperty(value="currencyType")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String currencyType;
    @JsonProperty(value="decimals")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer decimals;
    @JsonProperty(value="localizationDescriptions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, String> localizationDescriptions;

    @JsonIgnore
    public String getCurrencyType() {
        return this.currencyType;
    }

    @JsonIgnore
    public CurrencyType getCurrencyTypeAsEnum() {
        return CurrencyType.valueOf(this.currencyType);
    }

    @JsonIgnore
    public void setCurrencyType(String currencyType) {
        this.currencyType = currencyType;
    }

    @JsonIgnore
    public void setCurrencyTypeFromEnum(CurrencyType currencyType) {
        this.currencyType = currencyType.toString();
    }

    @JsonIgnore
    public CurrencyCreate createFromJson(String json) throws JsonProcessingException {
        return (CurrencyCreate)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<CurrencyCreate> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<CurrencyCreate>>(){});
    }

    public static CurrencyCreateBuilder builder() {
        return new CurrencyCreateBuilder();
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public Integer getDecimals() {
        return this.decimals;
    }

    public Map<String, String> getLocalizationDescriptions() {
        return this.localizationDescriptions;
    }

    @JsonProperty(value="currencyCode")
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @JsonProperty(value="currencySymbol")
    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    @JsonProperty(value="decimals")
    public void setDecimals(Integer decimals) {
        this.decimals = decimals;
    }

    @JsonProperty(value="localizationDescriptions")
    public void setLocalizationDescriptions(Map<String, String> localizationDescriptions) {
        this.localizationDescriptions = localizationDescriptions;
    }

    @Deprecated
    public CurrencyCreate(String currencyCode, String currencySymbol, String currencyType, Integer decimals, Map<String, String> localizationDescriptions) {
        this.currencyCode = currencyCode;
        this.currencySymbol = currencySymbol;
        this.currencyType = currencyType;
        this.decimals = decimals;
        this.localizationDescriptions = localizationDescriptions;
    }

    public CurrencyCreate() {
    }

    public static class CurrencyCreateBuilder {
        private String currencyCode;
        private String currencySymbol;
        private Integer decimals;
        private Map<String, String> localizationDescriptions;
        private String currencyType;

        public CurrencyCreateBuilder currencyType(String currencyType) {
            this.currencyType = currencyType;
            return this;
        }

        public CurrencyCreateBuilder currencyTypeFromEnum(CurrencyType currencyType) {
            this.currencyType = currencyType.toString();
            return this;
        }

        CurrencyCreateBuilder() {
        }

        @JsonProperty(value="currencyCode")
        public CurrencyCreateBuilder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @JsonProperty(value="currencySymbol")
        public CurrencyCreateBuilder currencySymbol(String currencySymbol) {
            this.currencySymbol = currencySymbol;
            return this;
        }

        @JsonProperty(value="decimals")
        public CurrencyCreateBuilder decimals(Integer decimals) {
            this.decimals = decimals;
            return this;
        }

        @JsonProperty(value="localizationDescriptions")
        public CurrencyCreateBuilder localizationDescriptions(Map<String, String> localizationDescriptions) {
            this.localizationDescriptions = localizationDescriptions;
            return this;
        }

        public CurrencyCreate build() {
            return new CurrencyCreate(this.currencyCode, this.currencySymbol, this.currencyType, this.decimals, this.localizationDescriptions);
        }

        public String toString() {
            return "CurrencyCreate.CurrencyCreateBuilder(currencyCode=" + this.currencyCode + ", currencySymbol=" + this.currencySymbol + ", currencyType=" + this.currencyType + ", decimals=" + this.decimals + ", localizationDescriptions=" + this.localizationDescriptions + ")";
        }
    }

    public static enum CurrencyType {
        REAL("REAL"),
        VIRTUAL("VIRTUAL");

        private String value;

        private CurrencyType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

