/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CreditRequest
extends Model {
    @JsonProperty(value="amount")
    private Integer amount;
    @JsonProperty(value="expireAt")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String expireAt;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, ?> metadata;
    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String origin;
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String reason;
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String source;

    @JsonIgnore
    public String getOrigin() {
        return this.origin;
    }

    @JsonIgnore
    public Origin getOriginAsEnum() {
        return Origin.valueOf(this.origin);
    }

    @JsonIgnore
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    @JsonIgnore
    public void setOriginFromEnum(Origin origin) {
        this.origin = origin.toString();
    }

    @JsonIgnore
    public String getSource() {
        return this.source;
    }

    @JsonIgnore
    public Source getSourceAsEnum() {
        return Source.valueOf(this.source);
    }

    @JsonIgnore
    public void setSource(String source) {
        this.source = source;
    }

    @JsonIgnore
    public void setSourceFromEnum(Source source) {
        this.source = source.toString();
    }

    @JsonIgnore
    public CreditRequest createFromJson(String json) throws JsonProcessingException {
        return (CreditRequest)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<CreditRequest> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<CreditRequest>>(){});
    }

    public static CreditRequestBuilder builder() {
        return new CreditRequestBuilder();
    }

    public Integer getAmount() {
        return this.amount;
    }

    public String getExpireAt() {
        return this.expireAt;
    }

    public Map<String, ?> getMetadata() {
        return this.metadata;
    }

    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="amount")
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @JsonProperty(value="expireAt")
    public void setExpireAt(String expireAt) {
        this.expireAt = expireAt;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, ?> metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Deprecated
    public CreditRequest(Integer amount, String expireAt, Map<String, ?> metadata, String origin, String reason, String source) {
        this.amount = amount;
        this.expireAt = expireAt;
        this.metadata = metadata;
        this.origin = origin;
        this.reason = reason;
        this.source = source;
    }

    public CreditRequest() {
    }

    public static class CreditRequestBuilder {
        private Integer amount;
        private String expireAt;
        private Map<String, ?> metadata;
        private String reason;
        private String origin;
        private String source;

        public CreditRequestBuilder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public CreditRequestBuilder originFromEnum(Origin origin) {
            this.origin = origin.toString();
            return this;
        }

        public CreditRequestBuilder source(String source) {
            this.source = source;
            return this;
        }

        public CreditRequestBuilder sourceFromEnum(Source source) {
            this.source = source.toString();
            return this;
        }

        CreditRequestBuilder() {
        }

        @JsonProperty(value="amount")
        public CreditRequestBuilder amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        @JsonProperty(value="expireAt")
        public CreditRequestBuilder expireAt(String expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @JsonProperty(value="metadata")
        public CreditRequestBuilder metadata(Map<String, ?> metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="reason")
        public CreditRequestBuilder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public CreditRequest build() {
            return new CreditRequest(this.amount, this.expireAt, this.metadata, this.origin, this.reason, this.source);
        }

        public String toString() {
            return "CreditRequest.CreditRequestBuilder(amount=" + this.amount + ", expireAt=" + this.expireAt + ", metadata=" + this.metadata + ", origin=" + this.origin + ", reason=" + this.reason + ", source=" + this.source + ")";
        }
    }

    public static enum Source {
        ACHIEVEMENT("ACHIEVEMENT"),
        CONSUMEENTITLEMENT("CONSUME_ENTITLEMENT"),
        DLC("DLC"),
        GIFT("GIFT"),
        IAP("IAP"),
        IAPCHARGEBACKREVERSED("IAP_CHARGEBACK_REVERSED"),
        OTHER("OTHER"),
        PROMOTION("PROMOTION"),
        PURCHASE("PURCHASE"),
        REDEEMCODE("REDEEM_CODE"),
        REFERRALBONUS("REFERRAL_BONUS"),
        REFUND("REFUND"),
        REWARD("REWARD"),
        SELLBACK("SELL_BACK");

        private String value;

        private Source(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Origin {
        Epic("Epic"),
        GooglePlay("GooglePlay"),
        IOS("IOS"),
        Nintendo("Nintendo"),
        Oculus("Oculus"),
        Other("Other"),
        Playstation("Playstation"),
        Steam("Steam"),
        System("System"),
        Twitch("Twitch"),
        Xbox("Xbox");

        private String value;

        private Origin(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

