/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaseCustomConfig
extends Model {
    @JsonProperty(value="connectionType")
    private String connectionType;
    @JsonProperty(value="grpcServerAddress")
    private String grpcServerAddress;

    @JsonIgnore
    public String getConnectionType() {
        return this.connectionType;
    }

    @JsonIgnore
    public ConnectionType getConnectionTypeAsEnum() {
        return ConnectionType.valueOf(this.connectionType);
    }

    @JsonIgnore
    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    @JsonIgnore
    public void setConnectionTypeFromEnum(ConnectionType connectionType) {
        this.connectionType = connectionType.toString();
    }

    @JsonIgnore
    public BaseCustomConfig createFromJson(String json) throws JsonProcessingException {
        return (BaseCustomConfig)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<BaseCustomConfig> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<BaseCustomConfig>>(){});
    }

    public static BaseCustomConfigBuilder builder() {
        return new BaseCustomConfigBuilder();
    }

    public String getGrpcServerAddress() {
        return this.grpcServerAddress;
    }

    @JsonProperty(value="grpcServerAddress")
    public void setGrpcServerAddress(String grpcServerAddress) {
        this.grpcServerAddress = grpcServerAddress;
    }

    @Deprecated
    public BaseCustomConfig(String connectionType, String grpcServerAddress) {
        this.connectionType = connectionType;
        this.grpcServerAddress = grpcServerAddress;
    }

    public BaseCustomConfig() {
    }

    public static class BaseCustomConfigBuilder {
        private String grpcServerAddress;
        private String connectionType;

        public BaseCustomConfigBuilder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public BaseCustomConfigBuilder connectionTypeFromEnum(ConnectionType connectionType) {
            this.connectionType = connectionType.toString();
            return this;
        }

        BaseCustomConfigBuilder() {
        }

        @JsonProperty(value="grpcServerAddress")
        public BaseCustomConfigBuilder grpcServerAddress(String grpcServerAddress) {
            this.grpcServerAddress = grpcServerAddress;
            return this;
        }

        public BaseCustomConfig build() {
            return new BaseCustomConfig(this.connectionType, this.grpcServerAddress);
        }

        public String toString() {
            return "BaseCustomConfig.BaseCustomConfigBuilder(connectionType=" + this.connectionType + ", grpcServerAddress=" + this.grpcServerAddress + ")";
        }
    }

    public static enum ConnectionType {
        INSECURE("INSECURE"),
        TLS("TLS");

        private String value;

        private ConnectionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

