/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.wallet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.PlatformWalletConfigInfo;
import net.accelbyte.sdk.api.platform.models.PlatformWalletConfigUpdate;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdatePlatformWalletConfig
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/platforms/{platform}/wallet/config";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String platform;
    private PlatformWalletConfigUpdate body;

    @Deprecated
    public UpdatePlatformWalletConfig(String namespace, String platform, PlatformWalletConfigUpdate body) {
        this.namespace = namespace;
        this.platform = platform;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.platform != null) {
            pathParams.put("platform", this.platform);
        }
        return pathParams;
    }

    public PlatformWalletConfigUpdate getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.platform != null;
    }

    public PlatformWalletConfigInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new PlatformWalletConfigInfo().createFromJson(json);
    }

    public static UpdatePlatformWalletConfigBuilder builder() {
        return new UpdatePlatformWalletConfigBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPlatform() {
        return this.platform;
    }

    public PlatformWalletConfigUpdate getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setBody(PlatformWalletConfigUpdate body) {
        this.body = body;
    }

    public static class UpdatePlatformWalletConfigBuilder {
        private String namespace;
        private PlatformWalletConfigUpdate body;
        private String platform;

        public UpdatePlatformWalletConfigBuilder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public UpdatePlatformWalletConfigBuilder platformFromEnum(Platform platform) {
            this.platform = platform.toString();
            return this;
        }

        UpdatePlatformWalletConfigBuilder() {
        }

        public UpdatePlatformWalletConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdatePlatformWalletConfigBuilder body(PlatformWalletConfigUpdate body) {
            this.body = body;
            return this;
        }

        public UpdatePlatformWalletConfig build() {
            return new UpdatePlatformWalletConfig(this.namespace, this.platform, this.body);
        }

        public String toString() {
            return "UpdatePlatformWalletConfig.UpdatePlatformWalletConfigBuilder(namespace=" + this.namespace + ", platform=" + this.platform + ", body=" + (Object)((Object)this.body) + ")";
        }
    }

    public static enum Platform {
        Epic("Epic"),
        GooglePlay("GooglePlay"),
        IOS("IOS"),
        Nintendo("Nintendo"),
        Oculus("Oculus"),
        Other("Other"),
        Playstation("Playstation"),
        Steam("Steam"),
        Xbox("Xbox");

        private String value;

        private Platform(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

