/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.wallet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.WalletTransactionPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicListUserWalletTransactions
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/users/{userId}/wallets/{currencyCode}/transactions";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String currencyCode;
    private String namespace;
    private String userId;
    private Integer limit;
    private Integer offset;

    @Deprecated
    public PublicListUserWalletTransactions(String currencyCode, String namespace, String userId, Integer limit, Integer offset) {
        this.currencyCode = currencyCode;
        this.namespace = namespace;
        this.userId = userId;
        this.limit = limit;
        this.offset = offset;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.currencyCode != null) {
            pathParams.put("currencyCode", this.currencyCode);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.currencyCode == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public WalletTransactionPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new WalletTransactionPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("limit", "None");
        result.put("offset", "None");
        return result;
    }

    public static PublicListUserWalletTransactionsBuilder builder() {
        return new PublicListUserWalletTransactionsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public static class PublicListUserWalletTransactionsBuilder {
        private String currencyCode;
        private String namespace;
        private String userId;
        private Integer limit;
        private Integer offset;

        PublicListUserWalletTransactionsBuilder() {
        }

        public PublicListUserWalletTransactionsBuilder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public PublicListUserWalletTransactionsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicListUserWalletTransactionsBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicListUserWalletTransactionsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PublicListUserWalletTransactionsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public PublicListUserWalletTransactions build() {
            return new PublicListUserWalletTransactions(this.currencyCode, this.namespace, this.userId, this.limit, this.offset);
        }

        public String toString() {
            return "PublicListUserWalletTransactions.PublicListUserWalletTransactionsBuilder(currencyCode=" + this.currencyCode + ", namespace=" + this.namespace + ", userId=" + this.userId + ", limit=" + this.limit + ", offset=" + this.offset + ")";
        }
    }
}

